-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
fe2: using(member_fe_init, member_window, terminalio, solicitor, calendar_display, events, times, itostr) 
     linking(solicitor, eventtostring, hhmmtotime, comp_times, itostr, timetohhmm)
     process (init: member_fe_init_in)
  declare
    parms: member_fe_init; -- initialization parameters
    username: charstring; -- what user I am
    continue: boolean; -- whether to remain as the front end
    notifycm: Notify_Appt; -- callmessage from notify
    
    solicitor: SolicitorOut; -- process to solicit input and report to terminalq
    eventtostring: EventToStringOut; -- makes events printable
    hhmmtotime: StringToTimeOut; -- reads times
    timetohhmm: TimeToStringOut; -- writes times
    comp_times : Time_Value_Call2_Return_Boolean_INTFACE_Caller; -- compares times
    conversion: charstring; -- for character to integer conversion
    itoa: disintegerFn; -- integer to character conversion
    terminalq_cap: putstringFunc; -- capability to terminalq
    commandcm: putStringIntf; -- command from terminal
    
    listed_appointments: table_of_events; -- last set of listed appointments
  begin
    receive parms from init;
    solicitor <- create of process solicitor;
    eventtostring <- procedure of process eventtostring;
    hhmmtotime <- procedure of process hhmmtotime;
    timetohhmm <- procedure of process timetohhmm;
    comp_times <- procedure of process comp_times;
    conversion <- "0123456789";
    itoa <- procedure of process itostr;
    connect terminalq_cap to parms.terminalq;
    
    -- Install solicitor.  It will solicit a command and call parms.terminalq.
    -- Wait for either a command from the solicitor or a notify request
    call solicitor(parms.terminal, "Enter 'plan', 'schedule', 'cancel', 'who', 'list', or 'new frontend':", terminalq_cap);
    continue <- 'true';
    new listed_appointments;
    while (continue)
      repeat
        block
          begin
            select
              event parms.terminalq
                receive commandcm from parms.terminalq;
                select (commandcm.string)
                  where("plan")
                    -- prompt for time ranges, participants
                    -- call plan
                    -- print uncontacted participants
                    -- print available time ranges
                    block
                      declare
                        last_time: time_value; -- last-time of last range
                        range: time_range; -- range of desired times
                        junkc: char;
                        start_time: charstring;
                        end_time: charstring;
                        participant: charstring;
                        participants: member_ids; -- desired participants
                        uncontacted_participants: member_ids;
                        desired_times: time_set;
                        available_times: time_set;
                      begin
                        call parms.terminal.putLine("Time Ranges, in order, ending in null line:");
                        block
                          begin
                            new desired_times;
                            unite last_time.The_Infinity from 'Neg_Inf';
                            while ('true')
                              repeat
                                call parms.terminal.putstring(">");
                                call parms.terminal.getstring(end_time);
                                if size of end_time = 0
                                  then
                                    exit Done;
                                  end if;
                                extract start_time from c in end_time where(position of c < position of cc in end_time where (cc = '-'));
                                remove junkc from end_time[0];
                                new range;
                                call hhmmtotime(start_time, range.begin_time);
                                call hhmmtotime(end_time, range.end_time);
                                if comp_times(range.end_time, range.begin_time)
                                  then
                                    exit IllegalRange;
                                  end if;
                                if comp_times(range.begin_time, last_time)
                                  then
                                    exit OutOfOrder;
                                  else
                                    last_time := range.begin_time;
                                    insert range into desired_times;
                                  end if;
                              end while;
                          on exit(done)
                          end block;
                        call parms.terminal.PutLine("Participants - end with null line");
                        new participants;
                        block 
                          begin
                            while ('true')
                              repeat
                                call parms.terminal.putstring(">");
                                call parms.terminal.getstring(participant);
                                if size of participant = 0
                                  then 
                                    exit done;
                                  else
                                    insert participant into participants;
                                  end if;
                              end while;
                          on exit(done)
                          end block;
                        call parms.plan(desired_times, participants, uncontacted_participants, available_times);
                        if size of uncontacted_participants > 0
                          then
                            call parms.terminal.putLine("These participants were not available:");
                            for p in uncontacted_participants[]
                              inspect
                                call parms.terminal.putLine(p);
                              end for;
                          else
                            call parms.terminal.putLine("All participants were available");
                          end if;
                        call parms.terminal.putLine("Available times:");
                        for t in available_times[]
                          inspect
                            call parms.terminal.putLine(timetohhmm(t.begin_time)|" -- "|timetohhmm(t.end_time));
                          end for;
                      on exit(IllegalRange)
                        call parms.terminal.putLine("Illegal Range");         
                      on exit(OutOfOrder)
                        call parms.terminal.putLine("Ranges not in order");
                      on (NotFound)
                        call parms.terminal.putLine("Syntax error");
                      on (Plan_appt.discarded)
                        call parms.terminal.PutLine("Plan failed");
                      end block;
                    return commandcm;
                  where("schedule")
                    -- prompt for information
                    -- call member
                    -- if scheduled, say so.
                    -- if not scheduled, say who couldn't participate
                    block
                      declare
                        range: time_range;
                        annotation: charstring;
                        location: charstring;
                        participants: member_ids;
                        unscheduled_participants: member_ids;
                        participant: charstring;
                      begin
                        new range;
                        call parms.terminal.putString("From:");
                        call hhmmtotime(parms.terminal.getString(), range.begin_time);
                        call parms.terminal.putString("To:");
                        call hhmmtotime(parms.terminal.getstring(), range.end_time);
                        if comp_times(range.end_time, range.begin_time)
                          then
                            exit IllegalRange;
                          end if;
                        call parms.terminal.putstring("Annotation:");
                        call parms.terminal.getstring(annotation);
                        call parms.terminal.putstring("Location:");
                        call parms.terminal.getstring(location);
                        call parms.terminal.putLine("Participants - end with null line");
                        new participants;
                        block 
                          begin
                            while ('true')
                              repeat
                                call parms.terminal.putstring(">");
                                call parms.terminal.getstring(participant);
                                if size of participant = 0
                                  then 
                                    exit done;
                                  else
                                    insert participant into participants;
                                  end if;
                              end while;
                          on exit(done)
                          end block;
                        call parms.schedule(range, participants, annotation, location, 'false', unscheduled_participants);
                        call parms.terminal.putLine("Scheduled.");
                      on exit (IllegalRange)
                        call parms.terminal.putLine("Illegal Range");
                      on (StringToTime.ConversionError)
                        call parms.terminal.putLine("Invalid Time");
                      on (Schedule_appt.not_scheduled)
                        call parms.terminal.putLine("Not scheduled -- these participants could not accept");
                        for unscheduled_participant in unscheduled_participants[]
                          inspect
                            call parms.terminal.putLine(unscheduled_participant);
                          end for;
                      end block;
                    return commandcm;
                  where("cancel")
                    -- sort the listed_appointments
                    -- cancel the named one
                    block
                      declare
                        appts: table_of_events;
                        appt: charstring; -- string number of appointment
                        apptno: integer; -- converted version of number
                        reason: charstring;
                        The_Event: An_Event;
                      begin
                        appts := listed_appointments;
                        call parms.terminal.PutString("Appointment Number:");
                        call parms.terminal.GetString(appt);
                        apptno <- 0;
                        for c in appt[]
                          inspect
                            apptno <- 10*apptno + position of cc in conversion where(cc=c);
                          end for;
                        while (size of appts > size of listed_appointments - apptno)
                          repeat
                            remove The_Event from e in appts where(not exists of e1 in appts where(comp_times(e1.scheduled_time.begin_time, e.scheduled_time.begin_time)));
                            if size of appts = size of listed_appointments - apptno
                              then
                                call parms.cancel(The_Event.Event_Id, reason);
                                call parms.terminal.PutLine("Cancelled.");
                                exit Done;
                              end if; 
                          end while;
                        exit BadNumber;
                      on (cancel_appt.not_cancelled)
                        call parms.terminal.PutLine("Not cancelled because "|reason);
                      on (NotFound)
                        call parms.terminal.PutLine("Invalid number "|appt);
                      on exit(BadNumber)
                        call parms.terminal.PutLine("Invalid number "|appt);
                      on exit(Done)
                      end block;
                    return commandcm;
                  where("who")
                    block
                      declare
                        members: members; -- everybody in the system
                      begin
                        call parms.list_members(members);
                        for member in members[]
                          inspect
                            call parms.terminal.putLine(member.name|" "|member.office|" "|member.phone);
                          end for;
                      end block; 
                    return commandcm;
                  where("list")
                    -- list appointments in order of start-time.
                    -- precede each with a number (1-based for humans)
                    block
                      declare
                        range: time_range;
                        appts: table_of_events;
                        The_Event: An_Event;
                      begin
                        new range;
                        unite range.begin_time.The_Actual_Time from 0;
                        unite range.end_time.The_Actual_Time from 2400;
                        appts <- parms.list_appts(range);
                        listed_appointments := appts;
                        if size of appts = 0
                          then
                            call parms.terminal.putLine("No appointments");
                          end if;
                        while (size of appts > 0)
                          repeat
                            call parms.terminal.PutLine(itoa(size of listed_appointments - size of appts + 1) | ":");
                            remove The_Event from e in appts where(not exists of e1 in appts where(comp_times(e1.scheduled_time.begin_time, e.scheduled_time.begin_time)));
                            call parms.terminal.PutLine(eventtostring(The_Event));
                          end while;
                      end block;
                    return commandcm;
                  where("new frontend")
                    call parms.terminal.putLine("quit");
                    continue <- 'false';
                    discard commandcm;
                  otherwise
                    call parms.terminal.putLine("Unrecognized command:"|commandcm.string);
                    return commandcm;
                  end select;
              event Parms.Notify
                receive notifycm from Parms.Notify;
                call parms.terminal.putline("An appointment was "|evaluate what: charstring from
                  if notifycm.whathappened = 'scheduled'
                    then
                      what := "scheduled!";
                    else
                      what := "cancelled!";
                    end if;
                  end);
                -- print event 
                call parms.terminal.putLine(eventtostring(notifycm.NewEvent));
                return notifycm;
              otherwise
              end select;
          end block;
      end while;
    return parms;
  end process  
