-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: member.p
-- Author: Arthur P. Goldberg

member: USING( 
    stdenv,
    terminalio,
    appt_scheduler_member, 
    appt_scheduler_registrant, 
    events, 
    master_internal, 
    member_fe_init, 
    member_init, 
    member_structs, 
    member_window, 
    rManager,
    safewindow,
    times , timesaux) 

LINKING( 
    -- difference_time_sets, 
    insert_tr_in_ts, 
    intersect_time_ranges,
    intersect_time_sets, 
    not_time_set

  )

  process (init: member_init_in)
  declare
    parms: member_init; -- initialization parameters
    username: charstring; -- userid
    terminal: terminalFunctions; -- for debugging only
    resource: rManager; -- for getting more resources
    register: add_member_out;  -- for joining the appointment scheduler
    -- front-end ports
    notify: notify_appt_out; -- for telling the front-end things
    plan: plan_appt_in; -- plan service
    schedule: schedule_appt_in; -- schedule service
    cancel: cancel_appt_in; -- cancel service
    list_appts: list_appts_in; -- list appointments service
    front_end_list_members: member_window!list_members_in; -- list members service
    
    plancm :  plan_appt; -- plan callmessage
    schedulecm :  schedule_appt; -- schedule callmessage
    cancelcm :  cancel_appt; -- cancel callmessage
    list_apptscm :  list_appts; -- list appointments callmessage
    front_end_list_memberscm :  member_window!list_members; -- list members callmessage
    
    -- appt_scheduler ports
    Request_Plan_Info : Request_Plan_Info_In;
    Inform_Schedule : Inform_Schedule_In;
    Inform_Cancel : Inform_Cancel_In;
    Shutdown : Shutdown_In;
    Reset_Member : Reset_Member_In;
    
    Request_Plan_Info_Out : Request_Plan_Info_Out;
    Inform_Schedule_Out : Inform_Schedule_Out;
    Inform_Cancel_Out : Inform_Cancel_Out;
    Shutdown_Out : Shutdown_Out;
    Reset_Member_Out : Reset_Member_Out;
    
    -- cm's for these ports
    Request_Plan_Infocm : Request_Plan_Info;
    Inform_Schedulecm : Inform_Schedule;
    Inform_Cancelcm : Inform_Cancel;
    Shutdowncm : Shutdown;
    Reset_Membercm : Reset_Member;
    
    -- trace information
    opentracewindow: safewindowFn;
    tracewindow: terminalCM;

    
    Self : Member;
    Running : Boolean;
    
    -- tables
    Personal_Events : Table_Of_Personal_Events;
    Group_Events : Table_Of_Events;
    
    Initiate_Plan: Initiate_Plan_Out;
    Initiate_Schedule: Initiate_Schedule_Out;
    Initiate_Cancel: Initiate_Cancel_Out;
    List_Members: appt_scheduler_member!List_Members_Out;
    List_Events: List_Events_Out;
    Depart: Depart_Out;
    
    -- procedures
    -- union_time_sets : Time_Set_In2_Out1_Procedure_Caller;
    not_time_set : Time_Set_In1_Out1_Procedure_Caller;
    intersect_time_sets : Time_Set_In2_Out1_Procedure_Caller;
    intersect: Time_Range_In2_Out1_Procedure_Caller;
    -- difference_time_sets : Time_Set_In2_Out1_Procedure_Caller;
    insert_tr_in_ts : Ins_TR_In_TS_Procedure_Caller;
    
    -- Never = [ +OO, +OO )
    Never : Time_Range;
  begin
    
    new Never;
    unite Never.Begin_Time.The_Infinity from 'Pos_Inf';
    unite Never.End_Time.The_Infinity from 'Pos_Inf';
    new Group_Events;
    -- difference_time_sets <- procedure of process difference_time_sets;
    insert_tr_in_ts <- procedure of process insert_tr_in_ts;
    intersect <- procedure of process intersect_time_ranges;
    intersect_time_sets <- procedure of process intersect_time_sets;
    not_time_set <- procedure of process not_time_set;
    
    receive parms from init;
    username := parms.username;
    terminal := parms.terminal;
    resource := parms.resource;
    register := parms.register;
    notify := parms.notify;
    new plan; connect parms.plan to plan;
    new schedule; connect parms.schedule to schedule;
    new cancel; connect parms.cancel to cancel;
    new list_appts; connect parms.list_appts to list_appts;
    new front_end_list_members; connect parms.list_members 
       to front_end_list_members; 
       
    unwrap opentracewindow from resource.get("OpenTraceWindow", "member "|username) {init};
    tracewindow <- opentracewindow("trace member "|username, "-Wh 12 -Ww 40 -inverse");
    
    
    new Self ;
    Self.Name := username ;
    Self.Member_ID := "" ;
    Self.phone := "" ;
    Self.office := "" ;
    
    new Request_Plan_Info;
    new Inform_Schedule;
    new Inform_Cancel;
    new Shutdown;
    new Reset_Member;
    
    connect Request_Plan_Info_Out to Request_Plan_Info;
    connect Inform_Schedule_Out to Inform_Schedule;
    connect Inform_Cancel_Out to Inform_Cancel;
    connect Shutdown_Out to Shutdown;
    connect Reset_Member_Out to Reset_Member;
    call tracewindow.terminal.PutLine("Calling Register");
    
    block begin
        call register (Self,
            Request_Plan_Info_Out, 
            Inform_Schedule_Out, 
            Inform_Cancel_Out, 
            Shutdown_Out, 
            Reset_Member_Out, 
            Initiate_Plan,
            Initiate_Schedule,
            Initiate_Cancel,
            List_Members,
            List_Events,
            Depart);
         call tracewindow.terminal.PutLine("Call returned successfully");
         call tracewindow.terminal.PutLine("Returning initialization call");
         return parms;
      on (Add_Member.Add_Failed)
         call tracewindow.terminal.PutLine("Call returned unsuccessfully");
         call terminal.putline("Unable To Register:  duplicate userid");
         call tracewindow.terminal.PutLine("Returning initialization call unsuccessfully");
         discard parms;
         exit Quit;
      end block;
    
    
    
    
    new Personal_Events; 
    
    -- handle calls from the Member_Window and the Appt_Scheduler
    Running := 'true';
    while (Running) repeat
        
        select
            
            -- handle calls from the Appt_Scheduler
            
          event Request_Plan_Info
            receive Request_Plan_Infocm from Request_Plan_Info;
            call tracewindow.terminal.PutLine("Received Request Plan Info from Appt Scheduler");
            -- look at Personal_Events to determine available times
            block
              declare
                Unavailable_Times:Time_Set;
              begin
                new Unavailable_Times;
                -- Optimization - use Desired_Times to reduce scope of inspect
                for A_Personal_Event in Personal_Events 
                       where(A_Personal_Event.Conflict_P = 'true') inspect 
                    call insert_tr_in_ts(A_Personal_Event.The_Event.Scheduled_Time,
                        Unavailable_Times); 
                  end for;
                
                Request_Plan_Infocm.Available_Times := intersect_time_sets(
                    not_time_set(Unavailable_Times), Request_Plan_Infocm.Desired_Times);
              end block;
            call tracewindow.terminal.PutLine("Returning");
            return Request_Plan_Infocm;
            
          event Inform_Schedule
            receive Inform_Schedulecm from Inform_Schedule;
            call tracewindow.terminal.PutLine("Received Inform Schedule from Appt Scheduler");
            -- make sure it does not conflict with personal events
            block
              declare
                Unavailable_Times:Time_Set;
                Should_Be_Never:Time_Range;
                Must_Be_Never:Time_Range;
                Tmp_Event :An_Event;
              begin
                new Unavailable_Times;
                -- Optimization - use Desired_Times to reduce scope of inspect
                -- or maintain Unavailable_Times
                for A_Personal_Event in Personal_Events 
                       where(A_Personal_Event.Conflict_P = 'true') inspect 
                    call insert_tr_in_ts(A_Personal_Event.The_Event.Scheduled_Time,
                        Unavailable_Times); 
                  end for;
                
                for A_Time_Range in Unavailable_Times [] inspect 
                    if intersect(A_Time_Range, Inform_Schedulecm.The_Event.Scheduled_Time) <> Never
                      then   
                        exit cantschedule;
                      end if;
                  end for;
                
                -- no conflict
                -- notify front-end window
                call notify ( Inform_Schedulecm.The_Event,'scheduled');
                -- insert Event in group_events
                Tmp_Event := Inform_Schedulecm.The_Event;
                insert Tmp_Event into group_events;
                call tracewindow.terminal.PutLine("Returning successfully");
                return Inform_Schedulecm;
                
              on exit (cantschedule)
                call tracewindow.terminal.PutLine("Returning unsuccessfully");
                return Inform_Schedulecm exception Not_Scheduled;
              end block;
            
            
          event Inform_Cancel
            block
              declare
                Removed_Event :An_Event ;
                
              begin
                receive Inform_Cancelcm from Inform_Cancel;
                call tracewindow.terminal.PutLine("Received Inform Cancel from Appt Scheduler");
                -- remove Event from Group_Events
                remove Removed_Event from An_Event in Group_Events where 
                   (Inform_Cancelcm.Event_ID = An_Event.Event_ID );
                -- notify front-end window
                call notify ( Removed_Event ,'cancelled');
                call tracewindow.terminal.PutLine("Returning normally");
                return Inform_Cancelcm;
              on (NotFound)
                call tracewindow.terminal.PutLine("Returning unsuccessfully");
                return Inform_Cancelcm exception Not_Cancelled;
              end block;
            
          event Shutdown
            receive Shutdowncm from Shutdown;
            call tracewindow.terminal.PutLine("Received shutdown from Appt Scheduler");
            Running := 'false';
            call tracewindow.terminal.PutLine("Returning");
            return Shutdowncm;
            
          event Reset_Member
            receive Reset_Membercm from Reset_Member;
            call tracewindow.terminal.PutLine("Received reset from Appt Scheduler");

            new Personal_Events; 
            call tracewindow.terminal.PutLine("Returning");
            return Reset_Membercm;
            
          -- handle calls from the front end 
          event plan
            receive plancm from plan;
            call tracewindow.terminal.PutLine("Received plan call from front end");
            -- plan:  just pass it on to the scheduler
            -- For now: if desired times and participants empty, this is
            -- really a shutdown
            if size of plancm.desired_times + size of plancm.desired_participants = 0
              then
                Running := 'false';
                new plancm.uncontacted_participants;
                new plancm.available_times;
              else
                call tracewindow.terminal.PutLine("Calling Scheduler - Initiate Plan");
                call Initiate_Plan(username, plancm.desired_times, plancm.desired_participants, plancm.uncontacted_participants, plancm.available_times);
                call tracewindow.terminal.PutLine("Returned successfully");
              end if;
	    call tracewindow.terminal.PutLine("Returning");
            return plancm;
          event schedule
            receive schedulecm from schedule;
            call tracewindow.terminal.PutLine("Received schedule call from front end");
            -- for now, no such thing as "private"
            -- if I am a participant,
            -- check that there is no conflict with group events
            -- before calling scheduler, and putting on my group events
            -- if I'm not a participant, put it on my
            -- personal calendar as a non-conflicting event
            -- and if there are other users,
            -- ask scheduler to schedule the appointment
            -- if scheduling failed, return the unscheduled participants to the caller
            block
              declare
                scheduled_event: event_id;
              begin
                if exists of schedulecm.expected_participants[username] and not schedulecm.conflict_p
                  then
		    if forall of appt in group_events where(intersect(schedulecm.time, appt.Scheduled_Time) = Never)
		      then
		        call tracewindow.terminal.PutLine("Calling scheduler - Initiate Schedule");
			call Initiate_Schedule(schedulecm.time, username, schedulecm.expected_participants, schedulecm.annotation, schedulecm.location, scheduled_event, schedulecm.Unscheduled_Participants);
			call tracewindow.terminal.PutLine("Returned successfully");
			insert evaluate appointment: An_Event from
			  new appointment;
			  appointment.scheduled_time := schedulecm.time;
			  appointment.organizer := username;
			  appointment.participants := schedulecm.expected_participants;
			  new appointment.planned_at;
			  unite appointment.planned_at.begin_time.The_Infinity from 'Neg_Inf';
			  unite appointment.planned_at.end_time.The_Infinity from 'Pos_Inf';
			  appointment.annotation := schedulecm.annotation;
			  appointment.location := schedulecm.location;
			  appointment.event_id := scheduled_event;
			  end into group_events;
			  call tracewindow.terminal.PutLine("Returning");
		          return schedulecm;
		      else
			new schedulecm.Unscheduled_participants;
			insert copy of username into schedulecm.Unscheduled_participants;
		        call tracewindow.terminal.PutLine("Returning");
			return schedulecm exception Not_Scheduled;
		      end if;
		  else
		    if exists of p in schedulecm.expected_participants where(p <> username)
		      then
		        call tracewindow.terminal.PutLine("Calling scheduler - Initiate Schedule");
		        call Initiate_Schedule(schedulecm.time, username, schedulecm.expected_participants, schedulecm.annotation, schedulecm.location, scheduled_event, schedulecm.Unscheduled_Participants);
		        call tracewindow.terminal.PutLine("Returned successfully");
		      else
		        scheduled_event := unique;
		      end if;
		    insert evaluate pe : personal_event from
		      new pe;
		      pe.conflict_p := 'false';
		      new pe.The_event;
		      pe.The_event.scheduled_time := schedulecm.time;
		      pe.The_event.organizer := username;
		      pe.The_event.participants := schedulecm.expected_participants;
		      new pe.The_event.planned_at;
		      unite pe.The_event.planned_at.begin_time.The_Infinity from 'Neg_Inf';
		      unite pe.The_event.planned_at.end_time.The_Infinity from 'Pos_Inf';
		      pe.The_event.annotation := schedulecm.annotation;
		      pe.The_event.location := schedulecm.location;
		      pe.The_event.event_id := scheduled_event;
		      end into personal_events;
		    call tracewindow.terminal.PutLine("Returning");
		    return schedulecm;
		  end if;
              on (initiate_schedule.Not_Scheduled)
                call tracewindow.terminal.PutLine("Returned Unsuccessfully");
                return schedulecm exception Not_Scheduled;
              end block;
              
          event cancel
            receive cancelcm from cancel;
            call tracewindow.terminal.PutLine("Received cancel call from front end");
            -- Try to remove it from the personal file.
            -- If it's not there, try to remove it from group.
            -- If it involves anyone else, call scheduler
            block
              declare
                deletedpappt: Personal_Event;
                deletedappt: An_Event;
              begin
		remove deletedpappt from appt in personal_events where(appt.the_event.event_id = cancelcm.the_appt);
		if exists of p in deletedpappt.The_Event.participants where(p <> UserName)
		  then
		    call tracewindow.terminal.PutLine("Calling Scheduler - Initiate Cancel");
		    call Initiate_Cancel(username, cancelcm.the_appt);
		    call tracewindow.terminal.PutLine("Returned Successfully");
		  end if;
		call tracewindow.terminal.PutLine("Returning");
		return cancelcm;
	      on (NotFound)
	        block
	          begin
		    remove deletedappt from appt in group_events where(appt.event_id = cancelcm.the_appt);
		    call tracewindow.terminal.PutLine("Calling Scheduler - Initiate Cancel");

		    call Initiate_Cancel(username, cancelcm.the_appt);
		    call tracewindow.terminal.PutLine("Returned Successfully");
		    call tracewindow.terminal.PutLine("Returning");
                    return cancelcm;
                  on (NotFound)
                    cancelcm.reason := "the appointment was already cancelled";
		    call tracewindow.terminal.PutLine("Returning");
                    return cancelcm exception Not_Cancelled;
                  on (Initiate_Cancel.Cancel_Not_Permitted)
		    call tracewindow.terminal.PutLine("Returned Unsuccessfully");
                    cancelcm.reason := "you are not the organizer";
                    insert deletedappt into group_events;
		    call tracewindow.terminal.PutLine("Returning");
                    return cancelcm exception Not_Cancelled;
                  end block;
              end block;
                
          event list_appts
            receive list_apptscm from list_appts;
            call tracewindow.terminal.PutLine("Received list_appts call from front end");
            -- get appointments in personal_events and group_events in
            --   time period requested  
            block
              begin
                new list_apptscm.appointments; 
                
                -- Problem: would be nice to give some order to the events
                for Personal in Personal_Events where(intersect(list_apptscm.Calendar_Period, Personal.The_Event.Scheduled_Time) <> Never) 
                  inspect 
                    insert copy of Personal.The_Event into list_apptscm.appointments;
                  end for;
                
                for An_Event in Group_Events where(intersect(list_apptscm.Calendar_Period, An_Event.Scheduled_Time) <> Never)
                  inspect 
                    insert copy of An_Event into list_apptscm.appointments;
                  end for;
                
              end block;
            call tracewindow.terminal.PutLine("Returning");
            return list_apptscm;
            
          event front_end_list_members
            receive front_end_list_memberscm from front_end_list_members;
            call tracewindow.terminal.PutLine("Received list_members call from front end");
            call tracewindow.terminal.PutLine("Calling scheduler - List Members");
            call List_Members (front_end_list_memberscm.TheMembers);
            call tracewindow.terminal.PutLine("Returned Successfully");
            call tracewindow.terminal.PutLine("Returning");
            return front_end_list_memberscm ;
            
          otherwise
          end select;
      end while;
    call tracewindow.terminal.putLine("Calling Scheduler - Depart");
    call Depart(username);
    call tracewindow.terminal.PutLine("Returned Successfully");
    call tracewindow.terminal.PutLine("Shutting Down");

  on exit(Quit)
  end process
