-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
eventtostring: using(calendar_display) linking(timetohhmm) process (init: EventToStringIn)
  declare
    parms: EventToString; -- call parameters
    timetohhmm: TimeToStringOut; -- converts times to strings
  begin
    receive parms from init;
    timetohhmm <- procedure of process timetohhmm;
    parms.string <- timetohhmm(parms.TheEvent.scheduled_time.begin_time);
    merge " -- " into parms.string;
    merge timetohhmm(parms.TheEvent.scheduled_time.end_time) into parms.string;
    merge " => " into parms.string;
    merge copy of parms.TheEvent.annotation into parms.string;
    insert 'NL' into parms.string;
    merge "Location: " into parms.string;
    merge copy of parms.TheEvent.location into parms.string;
    insert 'HT' into parms.string;
    merge "Organizer: " into parms.string;
    merge copy of parms.TheEvent.organizer into parms.string;
    insert 'NL' into parms.string;
    merge "Participants:" into parms.string;
    for participant in parms.TheEvent.Participants[]
      inspect
        insert ' ' into parms.string;
        merge copy of participant into parms.string;
      end for;
    return parms;
  end process
