-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: difference_time_sets.p
-- Author: Arthur P. Goldberg

-- find the difference between two time sets
-- call difference_time_sets( Input_Time_Set_1, Input_Time_Set_2, Output_Time_Set);

-- Output_Time_Set <- Input_Time_Set_1 difference Input_Time_Set_2

-- algorithm
-- Output_Time_Set <- Input_Time_Set_1 intersect not( Input_Time_Set_2 )

difference_time_sets: USING( times, terminalIO )
LINKING( not_time_set, intersect_time_sets )

PROCESS ( Call_Port : Time_Set_In2_Out1_Procedure_Receiver )
	DECLARE
		TCM : Time_Set_In2_Out1_INTFACE;
		intersect_time_sets : Time_Set_In2_Out1_Procedure_Caller;
		not_time_set : Time_Set_In1_Out1_Procedure_Caller;

		Not_Input_Time_Set_2 : Time_Set;
	BEGIN 
		RECEIVE TCM FROM Call_Port;
  		intersect_time_sets <- procedure of process intersect_time_sets;
  		not_time_set <- procedure of process not_time_set;

		Not_Input_Time_Set_2 := not_time_set(TCM.Input_Time_Set_2 );
		TCM.Output_Time_Set := intersect_time_sets(Not_Input_Time_Set_2,
			TCM.Input_Time_Set_1);

		return TCM;

end process
