-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: insert_tr_in_ts.p
-- Author: Arthur P. Goldberg

-- a call inserts Input_Time_Range into IO_Time_Set producing 
-- IO_Time_Set, a union of the Time_Ranges in IO_Time_Set and
-- the Input_Time_Range  
-- call insert_tr_in_ts( Input_Time_Range, IO_Time_Set) 

-- Algorithm
--		New_Time_Range := Input_Time_Range;
--		extract Intersecting_Time_Set from Time_Range in IO_Time_Set 
--			where(Time_Range.  etc ....
--		insert New_Time_Range into IO_Time_Set at the_right_place

insert_tr_in_ts: using (times)
LINKING( union_time_ranges, comp_times, Min_Time, Max_Time )

process ( Call_Port : Ins_TR_In_TS_Procedure_Receiver )

	declare
		TCM : Ins_TR_In_TS_INTFACE;
		Min_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Max_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		union_time_ranges: Time_Range_In2_Out2_Procedure_Caller;
		comp_times : Time_Value_Call2_Return_Boolean_INTFACE_Caller;

		Intersecting_Time_Set : Time_Set;
		New_Time_Range : Time_Range;
		Should_Be_Never_Time_Range : Time_Range;
		Result_Time_Range : Time_Range;
		Insert_Time_Range_Position : integer;
		Never : Time_Range;
		
	begin
		RECEIVE TCM FROM Call_Port;

  		Min_Time <- procedure of process min_time; 
  		Max_Time <- procedure of process max_time;
  		union_time_ranges <- procedure of process union_time_ranges;
		comp_times <- procedure of process comp_times; 

		extract Intersecting_Time_Set from Time_Range in TCM.IO_Time_Set
			where ( not( Comp_Times( 
				Min_Time(TCM.Input_Time_Range.End_Time, Time_Range.End_Time ),
				Max_Time(TCM.Input_Time_Range.Begin_Time,Time_Range.Begin_Time ))));

		new Never;
		unite Never.Begin_Time.The_Infinity from 'Pos_Inf';
		unite Never.End_Time.The_Infinity from 'Pos_Inf';

		new New_Time_Range;
		New_Time_Range := TCM.Input_Time_Range;
		for Time_Range in Intersecting_Time_Set where('true') inspect

				-- could optimize this to use just the first and last time_range
				-- in an ordered Intersecting_Time_Set
				call union_time_ranges(New_Time_Range, Time_Range,
					Result_Time_Range, Should_Be_Never_Time_Range ); 
				if (not(Should_Be_Never_Time_Range = Never)) then
					print charstring # "not(Should_Be_Never_Time_Range = Never))";
				end if;

				New_Time_Range := Result_Time_Range;

		end for;

		block begin
			Insert_Time_Range_Position := position of TR in TCM.IO_Time_Set
				where (Comp_Times( New_Time_Range.End_Time, TR.Begin_Time)); 
			on (NotFound) 
				Insert_Time_Range_Position := size of TCM.IO_Time_Set;
		end block;

		insert New_Time_Range into TCM.IO_Time_Set
			at Insert_Time_Range_Position;

		return TCM;

end process
