-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: intersect_time_ranges.p
-- Author: Arthur P. Goldberg

-- find the itersection of two time ranges
-- call intersect_time_ranges( In_Time_Range_1, In_Time_Range_2,
-- Out_Time_Range_1);

-- Out_Time_Range_1 <- In_Time_Range_1 intersect In_Time_Range_2
-- (Pos_Inf, Pos_Inf) = the empty time range

intersect_time_ranges: USING( times, timesaux, terminalIO )
LINKING(min_time, max_time, comp_times)

PROCESS ( Call_Port : Time_Range_In2_Out1_Procedure_Receiver )
	DECLARE
		TCM : Time_Range_In2_Out1_INTFACE;
		Max_Begin_Time : Time_Value;
		Min_End_Time : Time_Value;
		Min_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Max_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Comp_Times : Time_Value_Call2_Return_Boolean_INTFACE_Caller;
	BEGIN 
		RECEIVE TCM FROM Call_Port;
		-- call TCM.StdEnv.terminal.putline("Entry to intersect_time_ranges.");

  		Min_Time <- procedure of process min_time; 
  		Max_Time <- procedure of process max_time;
		Comp_Times <- procedure of process comp_times; 

		Max_Begin_Time := Max_Time (TCM.Input_Time_Range_1.Begin_Time, 
			TCM.Input_Time_Range_2.Begin_Time);

		Min_End_Time := Min_Time (TCM.Input_Time_Range_1.End_Time, 
			TCM.Input_Time_Range_2.End_Time);


		new TCM.Output_Time_Range_1;

		if ( Comp_Times( Max_Begin_Time, Min_End_Time ) ) then  
			TCM.Output_Time_Range_1.Begin_Time := Max_Begin_Time;
			TCM.Output_Time_Range_1.End_Time := Min_End_Time;
		else
			-- would prefer to have a constant time range called 'Never'
			unite TCM.Output_Time_Range_1.Begin_Time.The_Infinity from 'Pos_Inf';
			unite TCM.Output_Time_Range_1.End_Time.The_Infinity from 'Pos_Inf';
		end if;

		return TCM;

end process
