-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
timetohhmm: using(calendar_display, times) process (init: TimeToStringIn)
  declare
    parms: TimeToString; -- call parameters
    residual: integer; -- residual modulo 24*60
    conversion: charstring; -- integer to character mapping
    hours: integer; -- hours component
    minutes: integer; -- minutes component
    am: boolean; -- true if am
  begin
    receive parms from init;
    conversion <- "0123456789";
    block
      begin
        reveal parms.time.The_Actual_Time;
        residual <- parms.time.The_Actual_Time mod 1440;
        hours <- residual/60;
        minutes <- residual mod 60;
        am <- hours < 12;
        if am
          then
          else
            hours <- hours - 12;
          end if;
        if hours = 0
          then
            hours <- 12;
          end if;
        new parms.string;
        insert evaluate leading_char: char from
          leading_char <- conversion[hours/10];
          if leading_char = '0'
            then
              leading_char <- ' ';
            end if;
          end into parms.string;
        insert conversion[hours mod 10] into parms.string;
        insert ':' into parms.string;
        insert conversion[minutes/10] into parms.string;
        insert conversion[minutes mod 10] into parms.string;
        if am
          then
            merge "am" into parms.string;
          else
            merge "pm" into parms.string;
          end if;
      on (CaseError)
        parms.string <- "-------";
      end block;
    return parms;
  end process
