-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
nullwindow:  using(safewindowgen, safewindow, terminalio, common) linking(safewindowgen) process (init: safewindowQ)
  declare 
    safewindowgen: safewindowgenFn; -- generate safewindow callmessage
    openwindow: safewindowQ; -- open window service port
    openRQ: safewindow; -- request to open a window
    terminalQ: terminalQ; -- port for receiving terminal functions as CM
    terminal: terminalFunctions; -- terminal functions for the window
    closeQ: signalQ; -- close service
    putStringQ: putStringQ;	-- print a string
    putLineQ: putStringQ;	-- print a string plus a newline
    getStringQ: getStringQ;	-- read a string 
    putCharQ: putCharQ;	-- print a character
    getCharQ: getCharQ;	-- get a character 
    close: signalPort; -- access to close signal for the window
    nothing: empty; -- close signal
    putStringCM: putStringIntf; -- putString request
    putLineCM: putStringIntf; -- putLine request
    getStringCM: getStringIntf; -- getString request
    putCharCM: putCharIntf; -- putChar request
    getCharCM: getCharIntf; -- getChar request
    continue: boolean; -- true until null window closed
  begin
    receive openRQ from init;
    safewindowgen <- procedure of process safewindowgen;
    new closeQ;
    new putStringQ; new PutLineQ; new getStringQ; new putCharQ;new getCharQ;
    new terminal; new terminalQ;
    connect close to closeQ;
    connect terminal.putString to putStringQ;
    connect terminal.putLine to putLineQ;
    connect terminal.getString to getStringQ;
    connect terminal.putChar to putCharQ;
    connect terminal.getChar to getCharQ;
    call safewindowgen(terminal, close, terminalQ);
    receive openRQ.terminal from terminalQ;
    return openRQ;

    -- service loop
    continue <- 'true';
    while (continue) 
      repeat
        select
          event putStringQ
            receive putStringCM from putStringQ;
            return putStringCM;
          event putLineQ
            receive putLineCM from putLineQ;
            return putLineCM;
          event getStringQ
            receive getStringCM from getStringQ;
            return getStringCM exception EndOfInput;
          event putCharQ
            receive putCharCM from putCharQ;
            return putCharCM;
          event getCharQ
            receive getCharCM from getCharQ;
            return getCharCM exception EndOfInput;
          event closeQ
            receive nothing from closeQ;
            continue <- 'false';
          otherwise
          end select;
      end while;
  end process
