/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: actions.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)actions.ch	1.9 5/10/91";
#endif

#include <stdio.h>
#include <string.h>

#include "cherm.h"
#include "storage.h"

#include "asmfunc.h"
#include "asm.h"

#include "predefined.cd"
#include "interpform.cd"
#include "actions.cd"

extern objectp keyqual;		/* from cherm */

hobject(Mainprog, nominal);	/* id of the main process */
hobject(Codemap, table);	/* all the generated code */
hobject(Processid, nominal);	/* id of the process being assembled */
hobject(Procnames, table);	/* maps names to process id's */
hobject(Labels, table);		/* labels encountered for a process */
hobject(Exits, table);		/* exits encountered for a process */
hobject(Backpatch, table);	/* label fix-ups */
hobject(Operand, table);
hobject(Operandlist, table);
object *Prog;
object *Stmt;

void
init_asm()
{
    void defmod_init();
    defmod_init();
    avl_new_table(Codemap, firstelem_key);
    avl_new_table(Procnames, firstelem_key);
    set_bottom(Mainprog);
}


void
end_asm(name)
char *name;
{
    char outfile[128];
    lobject(File);		/* charstring */
    lobject(Absprog);		/* predefined!program */
    lobject(PolyProg);		/* predefined!polymorph */
    lobject(PolyInfo);		/* interpform!polymorph_info */
    objectp defmod_resolve_typename();

    strcpy(outfile, name);
    strcat(outfile, ".po");
    chs_lit(File, outfile);

    new_program(Absprog);	/* create an empty absprog */
    avl_new_table(Absprog@program__definitions_modules, firstelem_key);
    avl_new_table(Absprog@program__programs, firstelem_key); 
    move(Absprog@program__main_program, Mainprog);
    move(Absprog@program__CODE_MAP, Codemap);
    set_bottom(PolyProg);
    new_record(PolyInfo, polymorph_info);
    copy(PolyInfo@polymorph_info__type, predefined_typename("program"));
    avl_new_table(PolyInfo@polymorph_info__typestate, whole_key);
    wrap(PolyProg, Absprog, PolyInfo->value.record);
    write(PolyProg, File);
}


objectp
new_object()
{
    objectp obj;

    obj = (objectp) malloc(sizeof(object));
    obj->tsdr = &dr_bottom;
    return(obj);    
}

void
init_proc(main, name, initport, envsize)
int main;
objectp initport;		/* predefined!typename: initport type */
int envsize;
char *name;
{
    char *nullstring = "";
    object *processid();

    Prog = new_object();	/* build up the interpform!prog */
    new_record(Prog, prog);
    copy(Processid, processid(name));
    ilit(Prog@prog__size, envsize);
    move(Prog@prog__type, initport);
    vec_new_table(Prog@prog__code, 0);
    chs_lit(Prog@prog__name, name);
    chs_lit(Prog@prog__path, nullstring);
    chs_lit(Prog@prog__text, nullstring);
    chs_lit(Prog@prog__object, nullstring);
    ilit(Prog@prog__handle, 0);
    vec_new_table(Prog@prog__pool, 0);

    Stmt = new_object();

    avl_new_table(Labels, firstelem_key);

    avl_new_table(Backpatch, firstelem_key);

    avl_new_table(Exits, firstelem_key);

    if (main)
      if (Mainprog->tsdr->number isnt dr_bottom.number) {
	fprintf(stderr,
		"%s declared main process but already have a main process\n", 
		name);
      }
      else
	copy(Mainprog, Processid);
}


void
end_proc()
{
    hobject(Patchrec, record);	/* actions!backpatch_rec */
    hobject(Codemapentry, record); /* interpform!codemapEntry */
    if (obj_size_of(Backpatch) > 0) {
	fprintf(stderr, "The following labels were used but never defined:\n");

	initget(Patchrec, Backpatch, nil);
	while (get_or_err(Patchrec, Backpatch) is Normal)
	  fprintf(stderr, "  %s\n", stringval(Patchrec@backpatch_rec__label));
	endget(Patchrec, Backpatch);
    }
    new_record(Codemapentry, codemapentry);
    move(Codemapentry@codemapentry__processid, Processid);
    unique(Prog@prog__id);
    move(Codemapentry@codemapentry__liprog, Prog);
    insert(Codemap, Codemapentry);
}


objectp
processid(name)
char *name;
{
  hobject(Entry, record);
  hobject(Name, table);

  chs_lit(Name, name);
  if (h_lookup(Entry, Procnames, Name, 0) is NotFound) {
    new_record(Entry, printmap_rec);
    move(Entry@printmap_rec__name, Name);
    unique(Entry@printmap_rec__id);
    insert(Procnames, Entry);
  }
  return(Entry@printmap_rec__id);
}

void
init_stmt(opcode, label)
int opcode;
char *label;
{
    void labeldef();
    void init_operand_list();

    hobject(Stmtcopy, record);

    new_record(Stmt, operation);
    enum_lit(Stmt@operation__opcode, opcode);
    unite(Stmt@operation__qualifier, Bottom, qualifier_type__absent);

    init_operand_list();

    cheapcopy(Stmtcopy, Stmt);
    insert(Prog@prog__code, Stmtcopy);

    if (label) {
	labeldef(label);
    }
}


void
stmt_operand_list()
{
    move(Stmt@operation__operands, Operandlist);
}


void
init_operand_list()
{
    vec_new_table(Operandlist, 0);
}
    

void
add_operand()
{
    insert(Operandlist, Operand);
}


void
init_operand()
{
    vec_new_table(Operand, 0);
}


void
add_component(offset)
int offset;
{
    hobject(Off, integer);

    ilit(Off, offset);
    insert(Operand, Off);
}


void
q_boolean(val)
dfd_boolean val;
{
    hobject(Value, boolean);

    h_boolean(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__boolean);
}


void
q_integer(val)
dfd_integer val;
{
    hobject(Value, integer);

    ilit(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__integer);
}


void
q_charstring(val)
char *val;
{
    hobject(Value, chs_table);

    chs_lit(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__string);

    free_string(val);
}



void
q_proc(name)
char *name;
{
  object *processid();
  hobject(Procid, nominal);
  copy(Procid, processid(name));
  unite(Stmt@operation__qualifier, Procid, qualifier_type__program);
}



void
q_label(name)
char *name;
{
    hobject(Val, integer);
    hobject(Ref, variant);

    copy(Ref, Bottom);		/* pre-init for unite (groan) */
    unite(Ref, Bottom, labelref_type__branch);
    ilit(Val, labelref(name, Ref));
    unite(Stmt@operation__qualifier, Val, qualifier_type__integer);
}


void
q_labelpair(name, num, labelpos)
char *name;
int num;
int labelpos;
{
    hobject(Lpair, record);
    hobject(Ref, variant);
    hobject(Pos, integer);

    new_record(Lpair, integer_pair);
    if (labelpos == 1)
      ilit(Lpair@integer_pair__int_two, num);
    else
      ilit(Lpair@integer_pair__int_one, num);

    copy(Ref, Bottom);		/* pre-init for unite (groan) */
    ilit(Pos, labelpos);
    unite(Ref, Pos, labelref_type__labelpair);
    if (labelpos is 1)
      ilit(Lpair@integer_pair__int_one, labelref(name, Ref));
    else
      ilit(Lpair@integer_pair__int_two, labelref(name, Ref));
    unite(Stmt@operation__qualifier, Lpair, qualifier_type__integer_pair);
}



void
init_selectlist()
{
    hobject(Sellist, table);

    vec_new_table(Sellist, 0);
    unite(Stmt@operation__qualifier, Sellist, qualifier_type__select);
}


void
add_selectlabel(name)
char *name;
{
    hobject(Ref, variant);
    hobject(Selpos, integer);
    hobject(Labval, integer);
    

    h_size(Selpos, Stmt@operation__qualifier@Component);
    copy(Ref, Bottom);
    unite(Ref, Selpos, labelref_type__select);

    ilit(Labval, labelref(name, Ref));
    insert(Stmt@operation__qualifier@Component, Labval);
}




#define STATEMENTNUM 	(obj_size_of(Prog@prog__code)-1)

void
labeldef(name)
char *name;
{
    hobject(Label, record);
    hobject(Labname, chs_table);
    hobject(Zero, integer);
    hobject(Patch, record);
    hobject(FindPatch, record);
    hobject(St, record);
    hobject(Refst, record);
    hobject(Deadlabel, integer);
    hobject(Stnum, integer);
    hobject(Stcop, integer);
    hobject(Badhandler, record);

    new_record(Label, label_rec);
    chs_lit(Label@label_rec__label, name);
    ilit(Label@label_rec__statement, STATEMENTNUM);

    if (insert(Labels, Label) is DuplicateKey) {
	fprintf(stderr, "Label '%s' already defined.\n", name);
	return;
    }

    /* do the backpatching */

    chs_lit(Labname, name);
    ilit(Zero, 0);
    ilit(Stnum, STATEMENTNUM);

    if (h_lookup(FindPatch, Backpatch, Labname, 0) isnt NotFound) {
	fremove(Patch, FindPatch, Backpatch, PRIMARY_KEY);
	while (obj_size_of(Patch@backpatch_rec__reflist) isnt 0) {
	    remove_at(Refst, Patch@backpatch_rec__reflist, Zero);
	    lookup_at(St, Prog@prog__code,
			      Refst@labelref_rec__statement);

	    switch (obj_case_of(Refst@labelref_rec__ref)) {
	      case labelref_type__branch: {
		  copy(St@operation__qualifier@Component, Stnum);
		  break;
	      }

	      case labelref_type__labelpair: {
		  if (integerval(Refst@labelref_rec__ref@Component) is 1)
		    copy(St@operation__qualifier@Component@integer_pair__int_one,
			 Stnum);
		  else
		    copy(St@operation__qualifier@Component@integer_pair__int_two,
			 Stnum);
		  break;
	      }

	      case labelref_type__select: {
		  remove_at(Deadlabel, 
				    St@operation__qualifier@Component,
				    Refst@labelref_rec__ref@Component);
		  copy(Stcop, Stnum);
		  insert_at(St@operation__qualifier@Component, Stcop, 
				Refst@labelref_rec__ref@Component);
		  break;
	      }

	      case labelref_type__handler: {
		  h_lookup(Badhandler, St@operation__qualifier@Component,
			     Refst@labelref_rec__ref@Component, 0);
		  copy(Badhandler@block_handler__label, Stnum);
		  break;
	      }

	    }
	}
    }
}


int
labelref(name, Reftype)
char *name;
objectp Reftype;		/* constant labelref */
{
    hobject(Label, record);
    hobject(Labname, chs_table);
    hobject(Patch, record);
    hobject(Refrec, record);


    chs_lit(Labname, name);
    if (h_lookup(Label, Labels, Labname, 0) isnt NotFound) {
	discard(Reftype);
	return(integerval(Label@label_rec__statement));
    }

    /* label not found; put in backpatch */

    new_record(Refrec, labelref_rec);
    ilit(Refrec@labelref_rec__statement, STATEMENTNUM);
    move(Refrec@labelref_rec__ref, Reftype);

    if (h_lookup(Patch, Backpatch, Labname, 0) is NotFound) {
	new_record(Patch, backpatch_rec);
	chs_lit(Patch@backpatch_rec__label, name);
	vec_new_table(Patch@backpatch_rec__reflist, 0);
	insert(Patch@backpatch_rec__reflist, Refrec);
	insert(Backpatch, Patch);
    }
    else {
	insert(Patch@backpatch_rec__reflist, Refrec);
    }

    discard(Labname);

    return(-999);
}


q_exitid(name)
char *name;
{
    objectp addexit();
    objectp nameobjp;

    /* This used to just be:  
         unite(Stmt@operation__qualifier, addexit(name), qualifier_type__exit);
       but since unite is a macro from hcalls.h, and addexit also calls such
       a macro, and these macros set the GLOBAL variable _qh, this resulted
       in a very annoying bug.  

       Don't ever do this.
       */

    nameobjp = addexit(name);

    unite(Stmt@operation__qualifier, nameobjp, qualifier_type__exit);

}


objectp
addexit(name)
char *name;
{
    hobject(Exname, chs_table);
    hobject(Exit, record);
    objectp Exid;		/* nominal */

    Exid = new_object();

    chs_lit(Exname, name);
    if (h_lookup(Exit, Exits, Exname, 0) isnt NotFound) {
	copy(Exid, Exit@exit_rec__exitid);
	return(Exid);
    }

    new_record(Exit, exit_rec);
    move(Exit@exit_rec__name, Exname);
    unique(Exit@exit_rec__exitid);

    copy(Exid, Exit@exit_rec__exitid);

    insert(Exits, Exit);

    return(Exid);
}

void
q_exception(Userex)
objectp Userex;			/* predefined!user_exception */
{
    unite(Stmt@operation__qualifier, Userex, qualifier_type__exception);
}



void
q_intpair(int1, int2)
int int1, int2;
{
    hobject(Pair, record);

    new_record(Pair, integer_pair);
    ilit(Pair@integer_pair__int_one, int1);
    ilit(Pair@integer_pair__int_two, int2);

    unite(Stmt@operation__qualifier, Pair, qualifier_type__integer_pair);
}


objectp
ex_others()
{
    objectp Handlername;

    Handlername = new_object();
    unite(Handlername, Bottom, handler_type__others);

    return(Handlername);
}


objectp
ex_exit(name)
char *name;
{
    objectp addexit();

    objectp Handlername;


    Handlername = new_object();
    unite(Handlername, addexit(name), handler_type__exit);

    return(Handlername);
}


objectp
ex_builtin(excepnum)
int excepnum;
{
    hobject(Excep, enumeration);
    objectp Handlername;

    enum_lit(Excep, excepnum);
    Handlername = new_object();
    unite(Handlername, Excep, handler_type__builtin);

    return(Handlername);
}


objectp
ex_user(Userex)
objectp Userex;
{
    objectp Handlername;

    Handlername = new_object();
    unite(Handlername, Userex, handler_type__user);
    return(Handlername);
}


void
init_handlers()
{
    hobject(Handlers, table);

    avl_new_table(Handlers, firstelem_key);
    unite(Stmt@operation__qualifier, Handlers, qualifier_type__block);
}


void
add_handler(Exception, lab)
objectp Exception;
char *lab;
{
    hobject(Ref, variant);
    hobject(Excopy, variant);
    hobject(Handler, record);


    copy(Excopy, Exception);
    copy(Ref, Bottom);
    unite(Ref, Excopy, labelref_type__handler);

    new_record(Handler, block_handler);
    move(Handler@block_handler__handler, Exception);
    ilit(Handler@block_handler__label, labelref(lab, Ref));

    insert(Stmt@operation__qualifier@Component, Handler);
}



void
q_table(nonlookrep, lookupinfo)
int nonlookrep;
objectp lookupinfo;
{
    hobject(Ninfo, record);

    new_record(Ninfo, new_table_info);

    if (nonlookrep isnt -1) {
	unite(Ninfo@new_table_info__nonlookup, Bottom, nonlookrep);
    }
    else {
	unite(Ninfo@new_table_info__nonlookup, Bottom, table_rep_type__none);
    }

    if (lookupinfo) {
	unite(Ninfo@new_table_info__opt_reps, lookupinfo, option__present);
    }
    else {
	unite(Ninfo@new_table_info__opt_reps, Bottom, option__absent);
    }

    unite(Stmt@operation__qualifier, Ninfo, qualifier_type__new_table);
}


objectp Tblreps;

void
init_tblreps()
{
    Tblreps = new_object();

    vec_new_table(Tblreps, 0);
}


objectp
get_tblreps()
{
    return(Tblreps);
}


void
add_tblrep(repnum)
int repnum;
{
    hobject(Rep, variant);

    copy(Rep, Bottom);  unite(Rep, Bottom, repnum);
    insert(Tblreps, Rep);
}

objectp
q_lookupinfo(Replist, Keyset, Indexset)
{
    objectp Linfo;

    Linfo = new_object();
    new_record(Linfo, lookup_info);

    move(Linfo@lookup_info__reps, Replist);
    move(Linfo@lookup_info__keys, Keyset);
    move(Linfo@lookup_info__indices, Indexset);

    return(Linfo);
}

objectp Lookupset;

void
q_init_lookupset()
{
    Lookupset = new_object();
    vec_new_table(Lookupset, 0);
}

objectp 
q_get_lookupset()
{
    return(Lookupset);
}

void
q_add_lookup()
{
    if (obj_size_of(Operandlist) > 0)
      insert(Lookupset, Operandlist);
}


void
q_typename(type)
objectp type;
{
    unite(Stmt@operation__qualifier, type, qualifier_type__typename);
}


void
q_wrapper(type,ts)
objectp type,ts;
{
  lobject(Wrapper);

  new_record(Wrapper, polymorph_info);
  move(Wrapper@polymorph_info__type, type);
  move(Wrapper@polymorph_info__typestate, ts);
  unite(Stmt@operation__qualifier, Wrapper, qualifier_type__polymorph_info);
}

objectp
q_empty_typestate()
{
  objectp emptyts;

  emptyts = new(object);
  (void) avl_new_table(emptyts, whole_key);
  return(emptyts);
}
  

char *
copystring(src)
char *src;
{
    char *newstring;

    newstring = (char *) getmain((counter) strlen(src)+1);
    strcpy(newstring, src);
    return(newstring);
}


void
free_string(str)
char *str;
{
    if (str)
      freemain(str, (counter) strlen(str)+1);
}


