/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)asm.y	1.7 2/19/92 */

%token OPCODE INTEGER IDENTIFIER STRING ERROR BUILTIN_EXCEPTION
%token MAIN PROCESS END TRUE FALSE PAIR OTHERS TABLE
%token TYPENAME EXCEPTION EXITID HANDLERS SELECTARMS
%token USING WRAPPER EMPTYTS

%start start



%{
#include "li.h"
#include "asm.h"

object *q_empty_typestate(), *q_lookupinfo(), *defmod_resolve_typename();
object *ex_user(), *ex_others(), *ex_builtin(), *ex_exit();
object *defmod_resolve_userex(), *q_get_lookupset(), *get_tblreps();
object *new_object();
char *copystring();
%}


%union	{
	char *string;
	int integer;
	object *obj;
	env *envp;
	}

%type <string> modname;
%type <integer> opt_main;
%type <string> statement_label;
%type <string> label;
%type <obj> typestate;
%type <obj> lookupinfo;
%type <obj> type;
%type <obj> exception;
%type <obj> user_exception;
%type <obj> key_list;
%type <obj> intval_list;
%type <string> opt_statement_label;
%type <integer> opt_intval;
%type <obj> opt_lookupinfo;
%type <obj> opt_type;
%type <integer> intval;
%type <integer> excep;
%type <integer> operator;
%type <string> symbol;
%type <string> charstring;
%type <integer> INTEGER;
%type <integer> BUILTIN_EXCEPTION;
%type <integer> OPCODE;
%type <string> IDENTIFIER;
%type <string> STRING;

%%

/* TEXBEGIN */

start :	modname ':'
	{ init_asm(); }
	USING '(' defmod_name_s ')' proc procs 
	{ end_asm($1); } ;

modname: symbol { $$ = $1; } ;

procs: empty ;
procs: procs proc ;

proc : opt_main PROCESS symbol opt_type intval
  	{ init_proc($1, $3, $4, $5); } 
	statement_s END
	{ end_proc(); } ;

opt_main : MAIN { $$ = -1; } ;
opt_main : empty { $$ = 0; } ;

statement : opt_statement_label operator
	{ init_stmt($2, $1); }
	operand_s
	{ stmt_operand_list(); }
	opt_statement_qualifier ;

statement_qualifier : ',' qualifier ;

statement_label : label ':'
	{ $$ = $1; } ;

operand : '*'
	{ init_operand(); } ;
operand : true_operand ;

true_operand : true_operand '.' intval
	{ add_component($3); } ;
true_operand : intval
	{ init_operand(); add_component($1); } ;

label : symbol
	{ $$ = $1; } ;

/*
 * real qualifier is absent since it is not used in
 * the bootstrapping process.
 */

qualifier : PROCESS symbol
	{ q_proc($2); } ;
qualifier : label
	{ q_label($1); } ;
qualifier : EXITID symbol
	{ q_exitid($2); } ;
qualifier : TRUE
	{ q_boolean(nil_true); } ;
qualifier : FALSE
	{ q_boolean(nil_false); } ;
qualifier : intval
	{ q_integer($1); } ;
qualifier : charstring
	{ q_charstring($1); } ;
qualifier : PAIR intval intval
	{ q_intpair($2, $3); } ;
qualifier : PAIR intval label
	{ q_labelpair($3, $2, 2); };
qualifier : PAIR label intval
	{ q_labelpair($2, $3, 1); };
qualifier : label intval
	{ q_labelpair($1, $2, 1); } ;
qualifier : TYPENAME type
	{ q_typename($2); } ;
qualifier : EXCEPTION user_exception
	{ q_exception($2); } ;
qualifier : HANDLERS 
	{ init_handlers(); }
	opt_handlers ';' ;
qualifier : SELECTARMS
	{ init_selectlist(); }
	label_s ';' ;
qualifier : TABLE opt_intval opt_lookupinfo
  	{ q_table($2, $3); } ;
qualifier : WRAPPER type ',' typestate
	{ q_wrapper( $2, $4); } ;
typestate : EMPTYTS
	{ $$ = q_empty_typestate(); } ;
lookupinfo : intval_list key_list key_list
	{ $$ = q_lookupinfo($1, $2, $3); } ;

type : symbol '!' symbol
  	{ $$ = defmod_resolve_typename($1, $3); } ;

key :	{ init_operand_list(); }
	operand_s
	{ q_add_lookup(); } ;

handlers : handler ;
handlers : handlers ',' handler ;

handler : exception label
	{ add_handler($1, $2); } ;

exception : user_exception
	{ $$ = ex_user($1); } ;
exception : OTHERS
	{ $$ = ex_others(); } ;
exception : excep
	{ $$ = ex_builtin($1); } ;
exception : EXITID symbol
	{ $$ = ex_exit($2); } ;

user_exception : type '.' symbol
	{ $$ = defmod_resolve_userex($1, $3); } ;

/* TEXEND */

empty : ;

key_list : '(' 
	{ q_init_lookupset(); } 
	key_sublist ')'
	{ $$ = q_get_lookupset(); } ;

key_sublist : key ;
key_sublist : key_sublist ',' key  ;

intval_list : '(' 
  	{ init_tblreps(); }
	intval_sublist ')'
	{ $$ = get_tblreps(); } ;

intval_sublist : intval
	{ add_tblrep($1); } ;
intval_sublist : intval_sublist ',' intval
	{ add_tblrep($3); } ;

defmod_name_s : defmod_name_s symbol
	{ defmod_import($2); } ;
defmod_name_s : empty ;

statement_s : statement_s statement ;
statement_s : empty ;

opt_statement_qualifier : statement_qualifier ;
opt_statement_qualifier : empty ;

operand_s : operand_s operand
	{ add_operand(); } ;
operand_s : empty ;

opt_statement_label : statement_label
	{ $$ = $1; } ;
opt_statement_label : empty
	{ $$ = nil; } ;

opt_intval : intval 
  	{ $$ = $1; } ;
opt_intval : empty
	{ $$ = -1; } ;

opt_lookupinfo : lookupinfo
	{ $$ = $1; } ;
opt_lookupinfo : empty
	{ $$ = nil; } ;

opt_type : type
	{ $$ = $1; } ;
opt_type : empty
	{ $$ = new_object(); } ;	/* return bottom'ed object */

label_s : label_s label
	{ add_selectlabel($2); } ;
label_s : empty ;

opt_handlers : empty ;
opt_handlers : handlers ;


intval : INTEGER
	{ $$ = $1; } ;

excep : BUILTIN_EXCEPTION
	{ $$ = $1; } ;

operator : OPCODE 
	{ $$ = $1; } ;

symbol : IDENTIFIER
	{ $$ = copystring($1); } ;
symbol : MAIN
	{ $$ = "main"; } ;
charstring : STRING
	{ $$ = copystring($1); } ;

