/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* MiniC C-Type definitions
** Andy Lowry, Apr 1989
** SCCS Info: @(#)ctype.h	1.2 3/13/90
**/

/* We define a data structure to represent an arbitrary C datatype...
** typedefs for EXPR, CTYPE, and S_ENTRY must already exist (we define
** the structure to which CTYPE is typedef'ed here)
**/

typedef enum t_deriv {		/* individual type derivation steps */
  TD_POINTER,			/* pointer type, derived from type */
				/* pointed to */
  TD_ARRAY,			/* array type, derived from element type */
  TD_FUNC,			/* function type, derived from return type */
} T_DERIV;

typedef struct t_derivs {	/* specification for derivation of a */
				/* derived type */
  T_DERIV deriv;		/* code for one step in the derivation */
  EXPR *size;			/* declared size if deriv is TD_ARRAY */
  struct t_derivs *next;	/* more codes if needed */
} T_DERIVS;

struct ctype {			/* an arbitrary C type */
  int base;			/* flags for base types and modifiers */
  T_DERIV *derivs;		/* derivations on base type */
  S_ENTRY *ref;			/* when base type is a struct, union, */
				/* enum or typedef, this points to an */
				/* entry describing the referenced type */
};
