/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */

/* Filename: time.ch */
/* Author: Andy Lowry */
static char sccsInfo[] = "@(#)time.ch	1.6 8/28/91";

#include <sys/time.h>
#ifdef _IBMR2
#  include <time.h>
#endif

#include "cfunc.h"
#include "time.cd"
CProc(C_get_time)
{
  lobject(CMsg);
  objectp Initp;
  struct timeval tv;
  struct timezone tz;
  struct tm *t;
  char *ts;

  Initp = & current->ep.c->initport;

  copy(CMsg, Bottom);
  if (c_receive(CMsg, Initp) is SUCCESS) {

    if (gettimeofday(&tv, &tz) is -1)
      goto cleanup;
    else {
      t = localtime(&tv.tv_sec);
      ts = asctime(t);
      ts[strlen(ts)-1] = '\0';	/* strip newline */
      if (new_record(CMsg@getcurrenttimeintf__dateandtime, dateandtime)
	  isnt Normal)
	goto cleanup;
      copy(CMsg@getcurrenttimeintf__dateandtime@dateandtime__timezonename,
	   Bottom);
      copy(CMsg@getcurrenttimeintf__dateandtime@dateandtime__formattedtime,
	   Bottom);

      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__year,
	   t->tm_year + 1900);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__month,
	   t->tm_mon);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__day,
	   t->tm_mday);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__hour,
	   t->tm_hour);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__minute,
	   t->tm_min);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__second,
	   t->tm_sec);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__usecond,
	   tv.tv_usec);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__dayofweek,
	   t->tm_wday);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__dayofyear,
	   t->tm_yday);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__secondofepoch,
	   tv.tv_sec);
      h_boolean(CMsg@getcurrenttimeintf__dateandtime@dateandtime__dstineffect,
		t->tm_isdst);
      ilit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__timezoneoffset,
	   tz.tz_minuteswest);
      if (!chs_lit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__timezonename,
#if defined(hpux) || defined(_AIX)
		   daylight?tzname[1]:tzname[0]
#else
		   timezone(tz.tz_minuteswest, t->tm_isdst)
#endif
	   )
      )
	goto cleanup;
      if (!chs_lit(CMsg@getcurrenttimeintf__dateandtime@dateandtime__formattedtime,
		   ts))
	goto cleanup;

      c_return(sched, CMsg);
    }
  }
  else if (c_disconn(Initp)) {
    c_discard(sched, Initp);
    c_endprocess(sched, current);
  }
  else
    c_wait(sched, current, Initp); /* wait for next request */
  return;

 cleanup:			/* here when an allocation failed */
  if (!isbottom(CMsg@getcurrenttimeintf__dateandtime)) {
    if (!isbottom(CMsg@getcurrenttimeintf__dateandtime@dateandtime__timezonename))
      discard(CMsg@getcurrenttimeintf__dateandtime@dateandtime__timezonename);
    if (!isbottom(CMsg@getcurrenttimeintf__dateandtime@dateandtime__formattedtime))
      discard(CMsg@getcurrenttimeintf__dateandtime@dateandtime__formattedtime);
    discard(CMsg@getcurrenttimeintf__dateandtime);
  }
  c_discard(sched, CMsg);	/* wait for next request */
  c_wait(sched, current, Initp);
}
