-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chcombine.d	1.1 9/25/91

chcombine: using(common, getfile, interpform, listuff, load, objectio)

  definitions
    
    combiner : record(
	path : charstring,
	getfile : getFileFunc,
	rdobj : readobject_func,
	listuff : LIStuffFn,
	liunstuff : LIUnstuffFn,
	ccode : boolean,
	executable : boolean
      );
	
    combine_program : callmessage(
	name : charstring,
	cpr : combiner,
	program : predefined!program
      )
    constant(name, cpr)
    exit {full}
    minimum {init(name), full(cpr), full(program)}
    exception NoPor {init(name), full(cpr), full(program)}
    exception BadPor {init(name), full(cpr), full(program)}
    exception NoCode {init(name), full(cpr), full(program)};
    combine_programQ : inport of combine_program
       {init(name), full(cpr), full(program)};
    combine_programFn : outport of combine_programQ;
	
  end definitions
