-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chcombine.p	1.1 1/21/92

-- This process combines a .por file with a set of related .c files
-- producing a .po file.
--
-- Input is a list of process names and the associated .por files
-- (A .por file names is equivalent to a process name.)
-- If the first element in the list is a full unix path name, it is
-- treated as a common prefix for all file fetches and stores.
--
-- Output is the combined .po files.
--
--

chcombine: using(common, chcombine, cwd, getfile, interpform,
    listuff, load, main, objectio, rManager, terminalIO, unix)

  process(Q: MainQ)
    
  declare
    cm: Main;
    rm: rManager;
    args: charstringList;
    basepath: charstring;
    
    options: charstringList;
    ccode: boolean;
    executable: boolean;
    
    pathname: charstring;
    name: charstring;
    suffix: charstring;
    sz: integer;
    program: program;
   
    stdio: stdio;
    load: load_func;
    store: storeFunc;
    getCwd: getCwdFn;
    getFileInit: getFileInitFunc;
    combine: combine_programFn;
    cpr: combiner;
    
  begin
    
    receive cm from Q;
    rm := cm.rm;
    new cpr;
    
    unwrap load from rm.get("pathLoad", "*") {init};
    unwrap cpr.rdobj from rm.get("readObj", "*") {init};
    unwrap store from rm.get("store", "*") {init};
    
    unwrap stdio from rm.get("stdio", "*") {
      init, init(fopen), init(fdopen), init(popen), init(tmpfile),
      init(clearerrno), init(ctermid), init(cuserid), init(tmpnam),
      init(access), init(readErrno),

      init(stdin), init(stdin.getc), init(stdin.gets), init(stdin.fgets), 
      init(stdin.fread), init(stdin.getw), init(stdin.putc), 
      init(stdin.puts), init(stdin.fputs), init(stdin.fwrite),
      init(stdin.putw), init(stdin.fclose), init(stdin.pclose), 
      init(stdin.freopen), init(stdin.clearerr), init(stdin.ferror), 
      init(stdin.ferrno), init(stdin.feof), init(stdin.fflush), 
      init(stdin.fseek), init(stdin.rewind), init(stdin.ftell), 
      init(stdin.setlinebuf), init(stdin.fstat), init(stdin.fileno), 

      init(stdout), init(stdout.getc), init(stdout.gets), init(stdout.fgets), 
      init(stdout.fread), init(stdout.getw), init(stdout.putc), 
      init(stdout.puts), init(stdout.fputs), init(stdout.fwrite),
      init(stdout.putw), init(stdout.fclose), init(stdout.pclose), 
      init(stdout.freopen), init(stdout.clearerr), init(stdout.ferror), 
      init(stdout.ferrno), init(stdout.feof), init(stdout.fflush), 
      init(stdout.fseek), init(stdout.rewind), init(stdout.ftell), 
      init(stdout.setlinebuf), init(stdout.fstat), init(stdout.fileno), 

      init(stderr), init(stderr.getc), init(stderr.gets), init(stderr.fgets), 
      init(stderr.fread), init(stderr.getw), init(stderr.putc), 
      init(stderr.puts), init(stderr.fputs), init(stderr.fwrite),
      init(stderr.putw), init(stderr.fclose), init(stderr.pclose), 
      init(stderr.freopen), init(stderr.clearerr), init(stderr.ferror), 
      init(stderr.ferrno), init(stderr.feof), init(stderr.fflush), 
      init(stderr.fseek), init(stderr.rewind), init(stderr.ftell), 
      init(stderr.setlinebuf), init(stderr.fstat), init(stderr.fileno) };

    getFileInit <- create of load("getfile");
    cpr.getfile <- getFileInit(stdio.fopen);
    cpr.listuff <- procedure of load("listuff");
    cpr.liunstuff <- procedure of load("liunstuff");
    
    args := every of a in cm.argv where(position of a > 1);
    extract options from a in args where(a[0] = '-');
    cpr.ccode <- exists of option in options where(option = "-ccode");
    cpr.executable <- exists of option in options
       where(option = "-executable");
    
    if exists of firstname in args where(
	    position of firstname = 0 and firstname[0] = '/')
      then
	remove basepath from args[0];
      else
	unwrap getCwd from rm.get("getCwd", "*") {init};
	basepath <- getCwd();
      end if;
    cpr.path := basepath;
	
    combine <- procedure of process (Q: combine_programQ)
      declare
	cm: combine_program;
	pathname: charstring;
	program: program;
	prog0: prog;
	prog1: prog;
	code: code;
	pool: pooled_qualifiers;
	cx: integer;
	pqx: integer;
	op: operation;
	qual: interpform!qualifier;
      begin
	receive cm from Q;
	pathname <- cm.cpr.path | "/" | cm.name;
	prog0 <- cm.cpr.liunstuff(cm.program);
	prog0.path <- pathname | ".co";
	if cm.cpr.ccode then
	    prog0.text <- cm.cpr.getfile(pathname | ".c");
	  end if;
	if cm.cpr.executable then
	    prog0.object <- cm.cpr.getfile(pathname | ".co");
	  end if;
	-- scan for interpreted prog_lit instructions.
	code := prog0.code;
	for c in prog0.code[] inspect
	    if c.opcode = 'prog_lit' then
		cx <- position of c;
		remove op from code[cx];
		reveal op.qualifier.program;
		prog1 <- cm.cpr.liunstuff(op.qualifier.program);
		dissolve op.qualifier.program into program;
		call (combine_programFn#(create of currentprogram))
		   (prog1.name, cm.cpr, program);
		unite op.qualifier.program from program;
		insert op into code at cx;
	      end if;
	  end for;
	prog0.code <- code;
	pool := prog0.pool;
	-- scan for transformed program qualifiers.
	for pq in prog0.pool[] inspect
	    if case of pq = 'program' then
		pqx <- position of pq;
		remove qual from pool[pqx];
		reveal qual.program;
		prog1 <- cm.cpr.liunstuff(qual.program);
		dissolve qual.program into program;
		call (combine_programFn#(create of currentprogram))
		   (prog1.name, cm.cpr, program);
		unite qual.program from program;
		insert qual into pool at pqx;
	      end if;
	  end for;
	prog0.pool <- pool;
	call cm.cpr.listuff(cm.program, prog0);
	return cm;
      on (combine_program.NoPor)
	return cm exception NoPor;
      on (readobject_intf.file_not_readable, PolymorphMismatch,
	    combine_program.BadPor)
	return cm exception BadPor;
      on (getfile.CantRead, combine_program.NoCode)
	return cm exception NoCode;
      end process;
    
    for progname in args[] inspect
	name := progname;
	sz <- size of name - 4;
	extract suffix from c in name where(position of c >= sz);
	if suffix <> ".por" then
	    merge suffix into name;
	  end if;
	pathname <- basepath | "/" | name;
	block begin
	    unwrap program from cpr.rdobj(pathname | ".por")
	       {init(*), init(definitions_modules),
		init(main_program), init(programs)};
	    call combine(name, cpr, program);
	    call store(pathname | ".po", program);
	    call cm.terminal.putline(pathname | ".po combined");
	  on (readobject_intf.file_not_found, readobject_intf.Discarded)
	    call cm.terminal.putline(pathname | ".por not found");
	  on (readobject_intf.file_not_readable)
	    call cm.terminal.putline(pathname | ".por not readable");
	  on (PolymorphMismatch)
	    call cm.terminal.putline(pathname | ".por not program");
	  on (combine_program.NoCode)
	    call cm.terminal.putline(pathname | ": cant read .c or .co");
	  on (combine_program.NoPor)
	    call cm.terminal.PutLine(pathname | ": missing .por");
	  on (combine_program.BadPor)
	    call cm.terminal.PutLine(pathname | ": bad .por");
	  on (others)
	    call cm.terminal.PutLine(pathname | ": failed ??");
	  end block;
      end for;
    
    return cm;
   
  end process
