-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chdescriptors.d	1.1 9/25/91

chdescriptors: using(common, interpform)

  definitions
    
    statement_descriptors : table of statement_descriptor {full} KEYS(opcode);
    statement_descriptor : record(
	opcode : opcode,
	flow : instruction_flow,
	locus : execution_locus,
	destination : assignment,
	families : families,
	improve : improvement,
	choose : choice,
	operations : template_operations,
	parameters : template_parameters
      );

    execution_locus : ordered enumeration(
	'interpret',		-- residual code (eventually none)
	'block',		-- comprises a cblock of its own
					-- call, select, receive
	'escape',		-- entry to a non-blocking cblock
	'ccode',		-- element of a cblock
	'omit'			-- omited code
      );
        
    instruction_flow : ordered enumeration (
	'frame',		-- may branch - not in cblock
	'branch',		-- may branch (qualifier includes label(s))
	'emerge',		-- transfer control to handler or terminate
	'continue',             -- continue sequentially
	'ubiquitous'		-- here for convenience
      );
    
    families : ordered table of data_family {full};
    data_family : ordered enumeration (
        'boolean', 'enumeration', 'ordered_enumeration',
        'integer', 'real', 'string',
        'nominal', 'record', 'polymorph',
        'inport', 'outport',
	'callmessage', 'program',
        'variant', 'table', 'unknown'  -- ordering used in choperands
      );
    
    assignment : enumeration('referenced', 'modified', 'assigned');
    
    improvement : enumeration(
	'cbranch', 'convert', 'discard',
	'eliminate1', 'eliminate2', 'literal', 'move', 'select',
	'null'
      );
    
    choice : enumeration(
	'pure',
	'branch', 'compare', 'ubiquitous',
	'multiple', 'select',
	'zero_test',
	'null'
      );
    
    template_opcode : ordered enumeration (
	'char', 'string', 'operand', 'qualifier', 'parameter', 'variable',
	'line', 'choice', 'nest', 'iterate'
      );
    
    template_programs : table of template_program {full} KEYS(opcode);
    template_program : record(
	opcode : opcode,
	choose : choice,
	operations: template_operations
      );
    
    template_procedure : record(
	choose : choice,
	operations: template_operations
      );
    
    template_array : table of template_set {full} KEYS(name);
    template_set : record(
	name : charstring,
	operations : template_operations
      );
    
    template_operations : ordered table of template_operation {init};
    template_operation : variant of template_opcode(
	'char' -> char : char {init},
	'string' -> string : charstring {init},
	'operand' -> operand : template_operand {full},
	'qualifier' -> qualifier : empty {},
	'parameter' -> parameter : parameter_type {init},
	'variable' -> item : template_variable {init},
	'line' -> line : template_line {full},
	'choice' -> array : template_array {init},
	'nest' -> nested : template_procedure {full},
	'iterate' -> iterate : empty {}
      );
    
    template_operand : record(
	macro : operand_macro,
	index : integer
      );
    
    operand_macro : enumeration(
	'ADDRESS', 'OBJECT',  'VALCELL', 'TSDR', 'SCALAR'
      );
    
    template_parameters : table of template_parameter {full} KEYS(type);
    template_parameter : record(
	type : parameter_type,
	string : charstring
      );
    
    parameter_type : enumeration(
	'opcode',			-- opcode name (all)
	'modifier',			-- usually "!" or ""
	'operator',			-- for inline unary/binary/relation
	'function',			-- for function call - "<name>("
	'tsdr',				-- operand(s) representaion
	'tag',				-- operand(s) value tag
	'value'				-- operand's value (scalar/name)
      );
    
    template_line : record(
	newline : boolean,		-- emit newline now
	indent : integer		-- positive, zero, negative
      );
    
    template_variable : enumeration(
	-- side-effect only
	'increment',			-- increment encoding index
	'counter',			-- value of encoding index
	'int_one',			-- value of (first) integer (in pair)
	'int_two',			-- value of (second) integer (in pair)
	-- obtain statement label from (indexed) qualifier 
	'target_ccode',			-- original position of statement
	'target_statement'		-- execution position of statement
      );
    
  end definitions
