-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chencode.p	1.3 3/2/92

chencode: using(chdescriptors, chencode, chinternal, chphase3, chtransform,
    common, interpform)
linking(choperand, chqualifier, chencodings)

  process(Q: encodeQ)
    
  declare
    
    cm: encode;
    
    rand: encode_operandFn;
    qual: encode_qualifierFn;
    encodings: encodingsFn;
    
    stxs: statement_index_list;
    stx: integer;
    operations: template_operations;
    operation: template_operation;
    parameters: template_parameters;
    
    ccode: charstring;
    blocks: charstring;
    switch: charstring;
    label: charstring;
    line: charstring;
    nextline: charstring;
    part: charstring;
    nl: integer;
    suffix: char;
    indent: integer;
    linemax: integer;
    environment : encode_environment;
    counter: integer;
    opx: integer;
    previous: boolean;
    blocking: boolean;

  begin
    linemax := 78;
    receive cm from Q;
    rand <- procedure of process choperand;
    qual <- procedure of process chqualifier;
    encodings <- (encodingsInitFn#(create of process chencodings))();
	
    -- collect c-code (cm.cblocks, cm.statements, cm.operands, cm.string!)
    
    new environment;
    environment.statements := cm.statements;
    environment.operands := cm.operands;
    environment.cblocks := cm.cblocks;
    switch <- "select: switch (SELECTOR) {";
    pragma "initsize=5000;growby=1000" new blocks;
    merge "  }" into blocks;
    insert 'NL' into blocks;
    previous <- 'false';
    for cb in cm.cblocks[] inspect
	environment.cbx  <- position of cb;
	pragma "initsize=1000;growby=1000" new ccode;
	inspect st in cm.statements[cb.first] begin
	    if not (st.locus = 'omit' and st.opcode = 'escape') then
		blocking <- st.locus = 'block';
		if blocking then
		    blocking <- st.references <> 0 or size of cb.ingress > 1
		       or previous;
		  end if;
		label <- cm.ch.itoa(position of st);
		for cbx in cb.ingress[] inspect
		    insert 'NL' into switch;
		    merge "    case " into switch;
		    merge cm.ch.itoa(cbx) into switch;
		    merge ": goto c" into switch;
		    if blocking  then
			if cbx = environment.cbx then
			    insert 'b' into switch;
			  end if;
		      end if;
		    merge copy of label into switch;
		    insert ';' into switch;
		  end for;
		for sx in cb.otherlabels[] inspect
		    insert 'c' into ccode;
		    merge cm.ch.itoa(sx) into ccode;
		    insert ':' into ccode;
		    insert 'NL' into ccode;
		  end for;
		if blocking then
		    if st.references <> 0 or size of cb.ingress > 1 then
			insert 'c' into ccode;
			merge copy of label into ccode;
			insert ':' into ccode;
			insert 'NL' into ccode;
		      end if;
		    merge "  current->ip = " into ccode;
		    merge cm.ch.itoa(st.position) into ccode;
		    insert ';' into ccode;
		    insert 'NL' into ccode;
		    merge "cb" into ccode;
		  else
		    insert 'c' into ccode;
		  end if;
		merge copy of label into ccode;
		insert ':' into ccode;
		insert 'NL' into ccode;
	      end if;
	  end inspect;
	stxs := cb.statements;
	environment.stx <- -1;
	while size of stxs <> 0 repeat
	    remove environment.stx from stxs[0];
	    inspect st in cm.statements[environment.stx] begin
		if st.References <> 0 then
		    if environment.stx <> cb.first then
			line <- "c";
			merge cm.ch.itoa(position of st) into line;
			insert ':' into line;
			insert 'NL' into line;
			merge line into ccode;
		      end if;
		  end if;
		
		environment.select_flag <- 'false';
		environment.counter <- 0;
		inspect desc in cm.ch.descriptors[st.opcode] begin
		    parameters := desc.parameters;
		    if desc.choose = 'pure' then
			operations := desc.operations;
		      else
			new operations;
			call encodings(cm.ch, environment, desc.choose,
			    parameters, copy of desc.operations, operations);
		      end if;
		  end inspect;
		
		-- comment line for statement
		if cm.ch.options.comment then
		    inspect p in parameters['opcode'] begin
			line <- "/* ";
			merge copy of p.string into line;
		      end inspect;
		    for ox in st.operands[] inspect
			if ox < 0 then
			    merge " *" into line;
			  else
			    inspect op in cm.operands[ox] begin
				if op.Id[0] < 0 then
				    if case of op.Literal < 'none' then
					merge " =(" into line;
					merge rand('SCALAR', op, parameters,
					    cm.ch) into line;
					insert ')' into line;
				      else
					merge " ." into line;
				      end if;
				  else
				    suffix <- ' ';
				    for i in op.Id[] inspect
					insert suffix into line;
					merge cm.ch.itoa(i) into line;
					suffix <- '.';
				      end for;
				  end if;
			      end inspect;
			  end if;
		      end for;
		    if case of st.qualifier <> 'absent' then
			merge " , " into line;
			merge qual(st, cm.ch, cm.pool) into line;
		      end if;
		    merge " */" into line ;
		    insert 'NL' into line;
		    merge line into ccode;
		  end if;

		-- generate ccode for this statement

		line <- "  ";
		nextline <- "    ";
		counter <- 0;
		while size of operations <> 0 repeat
		    block begin
			remove operation from operations[0];
			select case of operation
			  where('char')
			    reveal operation.char;
			    insert copy of operation.char into line;
			    exit iterate;
			  where('string')
			    reveal operation.string;
			    part := operation.string;
			  where('operand')
			    reveal operation.operand;
			    if environment.select_flag then
				opx <- st.operands[operation.operand.index +
				       2*counter + 1];
			      else
				opx <- st.operands[operation.operand.index +
				       counter];
			      end if;
			    if opx < 0 then
				part <- "NO_OBJECT";
			      else
				part <- rand(operation.operand.macro,
				    cm.operands[opx],
				    parameters, cm.ch
				  );
			      end if;
			  where('qualifier')
			      part <- qual(st, cm.ch, cm.pool);
			  where('parameter')
			    reveal operation.parameter;
			    block begin
				inspect p in parameters[operation.parameter]
				  begin
				    part := p.string;
				  end inspect;
			      on (NotFound)
				part <- "/*PARAMETER*/";
			      end block;
			  where('variable')
			    select case of st.qualifier
			      where('integer')
				reveal st.qualifier.integer;
				stx := st.qualifier.integer;
			      where('select')
				reveal st.qualifier.select;
				if environment.select_flag then
				    stx <- st.qualifier.select[counter];
				  else
				    stx <- st.qualifier.select[counter/2];
				  end if;
			      where('integer_pair')
				reveal st.qualifier.integer_pair;
				select operation.item
				  where('int_one')
				    stx := st.qualifier.integer_pair.int_one;
				  where('int_two')
				    stx := st.qualifier.integer_pair.int_two;
				  otherwise -- it's some target (or irrelevant)
				    if st.opcode = 'oeloop' then
					stx :=
					   st.qualifier.integer_pair.int_one;
				      else -- 'find_or_goto'
					stx :=
					   st.qualifier.integer_pair.int_two;
				      end if;
				  end select;
			      otherwise
				stx <- -1;
			      end select;
			    reveal operation.item;
			    select operation.item
			      where('increment')
				counter <- counter + 1;
				exit iterate;
			      where('counter')
				part <- cm.ch.itoa(counter);
			      where('target_statement')
			        inspect s in cm.statements[stx] begin
				    part <- cm.ch.itoa(s.position);
				  end inspect;
			      otherwise --  'target_ccode', et al
				part <- cm.ch.itoa(stx);
			      end select;
			    merge part into line;
			    exit iterate;
			  where('line')
			    reveal operation.line;
			    indent := operation.line.indent;
			    while indent <> 0 repeat
				if indent < 0 then
				    remove suffix
				       from nextline[size of nextline - 1];
				    indent := indent + 1;
				  else
				    insert ' ' into nextline
				       at size of nextline;
				    indent := indent - 1;
				  end if;
			      end while;
			    if operation.line.newline then
				if exists of c in line where(c <> ' ') then
				    insert 'NL' into line;
				    merge line into ccode;
				    line := every of c in nextline
				       where(position of c > 1);
				  end if;
			      end if;
			    exit iterate;
			  where('choice')
			    merge "/*CHOICE*/" into line;
			    insert 'NL' into line;
			    merge line into ccode;
			    line := every of c in nextline
			       where(position of c > 1);
			    exit iterate;
			  where('nest')
			    merge "/*NEST*/" into line;
			    insert 'NL' into line;
			    merge line into ccode;
			    line := every of c in nextline
			       where(position of c > 1);
			    exit iterate;
			  where('iterate')
			    merge "/*ITERATE*/" into line;
			    insert 'NL' into line;
			    merge line into ccode;
			    line := every of c in nextline
			       where(position of c > 1);
			    exit iterate;
			  otherwise
			    exit iterate;
			  end select;
			nl <- size of line;
			if nl + size of part > linemax then
			    if nl <> size of nextline then
				insert 'NL' into line;
				merge line into ccode;
				line := nextline;
			      end if;
			  end if;
			merge part into line;
		      on exit(iterate)
		      end block;
		  end while;
		insert 'NL' into line;
		merge line into ccode;
	      end inspect;
	  end while;
	if environment.stx >= 0 then
	    inspect st in cm.statements[environment.stx] begin
		if st.locus = 'block' then
		    if st.opcode = 'select' then
			line <- "  if (current->ip == ";
			merge cm.ch.itoa(st.position) into line;
			merge ") return; else COMPUTE_TARGET;" into line;
		      else
			line <- "  return;";
		      end if;
		    insert 'NL' into line;
		    merge line into ccode;
		    previous <- 'false';
		  else
		    previous <- st.flow <> 'emerge' and st.opcode <> 'branch';
		  end if;
	      end inspect;
	  end if;
	merge ccode into blocks;
      end for;
    
    merge switch into cm.string;
    merge blocks into cm.string;
    
    return cm;

  end process
