-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_cbranch.p	1.1 1/21/92

chimprove_cbranch : using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: peeperQ)
    
  declare
    
    cm: peeper;
    
    st: ch_statement;
    lit: qualifier_literal;
    i: integer;
    j: integer;
    spx: integer;
    stx: integer;
    opcode: opcode;
    qual: interpform!qualifier;
    
  begin
    
    receive cm from Q;
    
    j <- size of cm.sxs - 1;
    stx <- cm.sxs[j];
    inspect st1 in cm.statements[stx] begin
	i <- st1.operands[0];
	inspect opd in cm.operands[i] begin
	    if case of opd.Literal = 'boolean' then
		lit := opd.Literal;
		reveal lit.boolean;
		if (st1.opcode = 'branch_true') <> lit.boolean then
		    exit drop;
		  else
		    call cm.adjust('referenced', i, cm.operands);
		    remove st from cm.statements[stx];
		    st.opcode <- 'branch';
		    new st.operands;
		    insert st into cm.statements at stx;
		    cm.continue <- 'true';
		  end if;
	      else
		if st1.references = 0 and j > 0 then
		    if opd.Assignments = 1 and opd.References = 2 then
			spx <- cm.sxs[j - 1];
			inspect st0 in cm.statements[spx] begin
			    inspect de in cm.ch.descriptors[st0.opcode] begin
				if de.choose = 'compare' then
				    if st0.operands[0] = i and 
					   case of st0.qualifier = 'absent'
				      then
					qual := st1.qualifier;
					if st1.opcode = 'branch_true' then
					    opcode := st0.opcode;
					  else -- reverse the comparison
					    select st0.opcode
					      where('equal')
						opcode <- 'notequal';
					      where('notequal')
						opcode <- 'equal';
					      where('ilt')
						opcode <- 'ige';
					      where('igt')
						opcode <- 'ile';
					      where('ile')
						opcode <- 'igt';
					      where('ige')
						opcode <- 'ilt';
					      where('oelt')
						opcode <- 'oege';
					      where('oegt')
						opcode <- 'oele';
					      where('oele')
						opcode <- 'oegt';
					      where('oege')
						opcode <- 'oelt';
					      where('rlt')
						opcode <- 'rge';
					      where('rgt')
						opcode <- 'rle';
					      where('rle')
						opcode <- 'rgt';
					      where('rge')
						opcode <- 'rlt';
					      otherwise -- can't happen
						exit unchanged;
					      end select;
					  end if;
					remove st from cm.statements[spx];
					st.opcode <- opcode;
					st.qualifier <- qual;
					insert st into cm.statements at spx;
					call cm.adjust('assigned', i,
					    cm.operands);
					exit drop;
				      end if;
				  end if;
			      end inspect;
			  end inspect;
		      end if;
		  end if;
	      end if;
	  end inspect;
      end inspect;
    return cm;
    
  on exit(unchanged)
    return cm;
  on exit(drop)
    return cm exception drop;
  end process
