-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)choperands.d	1.1 9/25/91

choperands: using(chphase1, chtransform, interpform)

  definitions
    
    containers : table of container {full} KEYS (*);
    container : record (
        base : operand,                 -- base is non-empty
        rest : operand                  -- full id = base | rest
      );
    
    
    opdict : table of operand {full} KEYS(*);
    
    optreelist : table of optree {full};
    optrees : table of optree {full} KEYS (component);
    optree : record(
	component : integer,		-- of operand id
	index : integer,		-- to ch_operands
	sum : counter,			-- direct + implied(outer) assignments
	content : optrees		-- sub-trees
      );
    
    search : callmessage(
	rest : operand,
	trees : optrees,
	search : searchFn,
	action : search_action
      )
    constant(search)
    exit {init(trees), init(search), init(action)}
    minimum {init(trees), init(search), init(action)};
    searchQ : inport of search {full};
    searchFn : outport of searchQ;
    
    search_function : enumeration ('enter', 'found', 'assign', 'findbase');
    search_action : variant of search_function(
	'enter' -> index : integer {init},
	'found' -> connect : connector {init, init(reply), init(operands)},
	'assign' -> cumulate : cumulator {init, init(sum), init(operands)},
	'findbase' -> operands : ch_operands {init}
      );
    
    cumulator : record(sum : counter, operands : ch_operands);
    connector : record(reply : boolean, operands : ch_operands);
    
    founded : callmessage(
	Id : operand,
	trees : optrees,
	search : searchFn,
	operands : ch_operands,
	reply : boolean
      )
    constant(Id, search)
    exit {full}
    minimum {init(Id), init(trees), init(search)};
    foundedQ : inport of founded
       {init(Id), init(trees), init(search), init(operands)};
    foundedFn : outport of foundedQ;
    
  end definitions
