-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cginit.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cginit.pp	1.46 2/15/92

-- This function loads code for other functions that will be needed by
-- the code generator, and initializes various "global" tables.

#include "typemark.h"
#include "codegen.h"

cgInit: using (interpform, common, cgInternal, cgInit)
#ifdef CGLINK
linking (optimize, cgclause, bbassemble,
  breakselector, cgselector, newtableinfo, cgatoi, cgator,
  clauseusesobj, lkuptype, varcaseid, cgstmt,
  cgdirectstmt, cgtypedstmt, typedef, compoffsets)  
#endif

process (Q: cgInitQ)

declare
  empty: empty;
  shutQ: signalQ;
  args: cgInit;
  -- signal ports that will cause the servers started by cgInit to
  -- shut down
  stmtShut: signalPort;
  directStmtShut: signalPort;
  typedStmtShut: signalPort;
  typeDefShut: signalPort;
  compOffsetsShut: signalPort;
begin
  receive args from Q;

  -- Establish 'shutdown' signal connection
  new shutQ;
  connect args.finish to shutQ;

  -- Fill in the auxiliary data record
  new args.cgData.Aux;
  block declare
    poly: polymorph;
  begin
    poly <- polymorph#(args.loadobj(S("opmap.obj")));
    unwrap args.cgData.Aux.opMap from poly {init};
  end block;

  -- Load all the functions and fill them in 
  new FNS;
  FNS.pathLoad := args.pathLoad;
  FNS.optimize <-optimizeFn#(PROCOF(optimize,"optimize"));
  FNS.BBAssemble <- BBAssembleFn#(PROCOF(bbassemble,"bbassemble"));
  FNS.cgClause <- cgClauseFn#(PROCOF(cgclause,"cgclause"));

  -- Server-style statement translators
  stmtShut <- signalPort#(
      (cgStmtInitFn#(CREATEOF(cgstmt,"cgstmt")))
          (FNS.cgStmt));
  directStmtShut <- signalPort#(
      (cgStmtInitFn#(CREATEOF(cgdirectstmt,"cgdirectstmt")))
          (FNS.cgDirectStmt));
  typedStmtShut <- signalPort#(
      (cgStmtInitFn#(CREATEOF(cgtypedstmt,"cgtypedstmt")))
	  (FNS.cgTypedStmt));

  --  Utility functions
  FNS.clauseUsesObj <-
      clauseUsesObjFn#(PROCOF(clauseusesobj,"clauseusesobj"));
  FNS.lkupType <- lkupTypeFn#(PROCOF(lkuptype,"lkuptype"));
  FNS.breakSelector <-
      breakSelectorFn#(PROCOF(breakselector,"breakselector"));
  FNS.cgSelector <- cgSelectorFn#(PROCOF(cgselector,"cgselector"));
  FNS.newTableInfo <- newTableInfoFn#(PROCOF(newtableinfo,"newtableinfo"));
  FNS.atoi <- atoiFn#(PROCOF(cgatoi,"cgatoi"));
  FNS.ator <- atorFn#(PROCOF(cgator,"cgator"));
  FNS.varCaseID <- varCaseIDFn#(PROCOF(varcaseid,"varcaseid"));

  -- Utility servers that need to be initialized with cgData
  typeDefShut <- signalPort#(
      (typeDefInitFn#(CREATEOF(typedef,"typedef")))
	  (args.cgData.Prog,FNS.typeDef));
  compOffsetsShut <- signalPort#(
      (compOffsetsInitFn#(CREATEOF(compoffsets,"compoffsets")))
	  (args.cgData.Prog,FNS.typeDef,FNS.compOffsets));

  -- following macro builds and installs an instruction template with
  -- no operands.
# define MKTPLT(name,code,qtype,qval) \
  block declare op: interpform!operation; begin \
    new op; op.opcode <- interpform!opcode@TYPEMARK@'code'; \
    new op.operands; \
    unite op.qualifier.qtype from qval; \
    args.cgData.Tplt.name <- op; \
  end block

  -- fill in instruction templates
  new args.cgData.Tplt;
  MKTPLT(boolF,boolean,boolean,FALSE);
  MKTPLT(boolT,boolean,boolean,TRUE);
  MKTPLT(noop,noop,empty,empty);
  MKTPLT(endblock,endblock,empty,empty);
  MKTPLT(endprocess,endprocess,empty,empty);
  MKTPLT(discard,discard,empty,empty);

  -- Initialize scratchpad information as needed
  new args.cgData.scratch;
  new args.cgData.scratch.selInfo;

  return args;			-- all done

  -- Now wait for the shutdown signal, and when it comes, shut down
  -- all the servers we started
  select
  event shutQ
    send empty to stmtShut;
    send empty to directStmtShut;
    send empty to typedStmtShut;
    send empty to typeDefShut;
    send empty to compOffsetsShut;
  otherwise
    exit cantHappen;
  end select;

on exit(cantHappen)
  print S("CantHappen exit taken in cginit");
end process
