-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: codegen.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)codegen.pp	1.18 2/15/92

-- This is the driver process for performing code generation for an
-- absprog.  After performing various initialization chores, we enter
-- a service loop that will codegen a single process from the absprog.

#include "typemark.h"
#include "codegen.h"

codegen: using (common, interpform, codegen, cgInternal, cgInit, unix)
#ifdef CGLINK
linking (cginit,cgprocess)
#endif

process (Q: codegenInitQ)

declare
  args: codegenInit;
  cgData: cgData;
  cgQ: codegenQ;
  finish: signalPort;
  empty: empty;
  cgProcess: cgProcessFn;
begin

  -- get the initialization request
  receive args from Q;

  -- consolidate some of the arguments into our grab-bag of relevant data
  new cgData;
  new cgData.Prog;
  cgData.Prog.defMods := args.absprog.definitions_modules;
  cgData.Prog.main_program := args.absprog.main_program;
  cgData.Prog.annotations := args.annotations;
  cgData.options := args.options;

  -- Gather up the capabilities we'll be needing, as well as various
  -- tables and other constant stuff...
  block declare
    cgInit: cgInitFn;
  begin
#ifdef CGLINK
    cgInit <- cgInitFn#(create of program#(process cgInit));
    cgProcess <- cgProcessFn#(procedure of program#(process cgProcess));
#else    
    cgInit <- cgInitFn#(create of program#(args.pathload(S("cginit"))));
    cgProcess <- cgProcessFn#(procedure of 
	  program#(args.pathload(S("cgprocess"))));
#endif
    call cgInit(args.pathLoad, args.pathReadObj, finish, cgData);
  end block;

  -- now set up to codegen individual proesses
  new cgQ;
  connect args.codegen to cgQ;
  return args;

  block declare
    cgArgs: codegen;
  begin
    while TRUE repeat
      receive cgArgs from cgQ;
      cgArgs.code <- 
	  interpform!prog#(cgProcess(cgArgs.proc,cgData));
      return cgArgs;
    end while;

  on (disconnected)		-- no more processes to compile
    send empty to finish;	-- shut down servers
  end block;

end process
