/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.12 11/5/90 */

#include "includefile"

LIBS	=	$(LIBDIRS) -lhermi -lcherm -lcfunc -lhermi -lfe -lhaux -ll \
		$(MACHLIBS)

YACC	=	yacc
YFLAGS	=	-v -d

all:	construct

construct:	parser.o construct.o $(HROOT)/fe/stubs.o \
		$(HROOT)/fe/standalone.o $(HROOT)/fe/main.o \
		$(HROOT)/cfunc/libcfunc.a $(HROOT)/fe/libfe.a \
		$(HROOT)/li/libhermi.a $(HROOT)/cherm/libcherm.a \
		$(HROOT)/lib/libhaux.a
	$(CC) $(CFLAGS) -o construct parser.o construct.o \
		$(HROOT)/fe/standalone.o $(HROOT)/fe/stubs.o \
		$(HROOT)/fe/main.o $(LIBS)

parser.c:	construct.yacc construct.h
	$(YACC) $(YFLAGS) construct.yacc
	mv y.tab.c parser.c
	mv y.tab.h tokens.h

construct.c:	construct.ch construct.h

lint:	construct
	$(LINT) $(LFLAGS) *.c

install:	all
	cp construct $(CONSTRUCT)

clean::
	rm -f y.tab.c y.tab.h construct y.output construct.c tokens.h parser.c

