/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: construct.ch */
/* Author: Jim Russell */
#ifndef lint
static char sccsinfo[] = "@(#)construct.ch	1.4 2/13/92";
#endif

/* many functions called by construct.yacc */
#include <stdio.h>

#include "li.h"
#include "../cherm/hcalls.h"
#include "storage.h"
#include "cherm.h"  /* ops.h also has set_bottom defined */
                    /* li/accessors.h also has size_of, case_of defined */
/* have to link with -lcherm to get h_qcall and _qh */
#include "../fe/resolve.h"

#include "construct.h"

#include "predefined.cd"
#include "errors.cd"
#include "interpform.cd"

/* definitions for the typename of the named type.  Use lookup_typename()
   to get the corresponding type_definition */
#define PredefinedCharstring (p_type_or_attr_name(p_qual_name("predefined", "charstring"), nil_true))
#define PredefinedTypename (p_type_or_attr_name(p_qual_name("predefined", "typename"), nil_true))
#define PredefinedAttributename (p_type_or_attr_name(p_qual_name("predefined", "attributename"), nil_true))
#define PredefinedFormalTypestate (p_type_or_attr_name(p_qual_name("predefined", "formal_typestate"), nil_true))




name_definition name_def_table[TABLESIZE];
int name_table_size;

objectp uninitobj;    /* represents an uninitialized object */
objectp bogus;       /* represents a bogus definition or inherit_att */
extern int atoi();
extern double atof();

extern objectp lookup_typename();
extern objectp p_type_or_attr_name();


void
c_init_construct()
{
  void c_init_absprog();

  /* initialize global name list */ 
  name_table_size = 0;
  /* initialize Absprog, so we can fake out definitions module routines */
  c_init_absprog();
  
  /* initialize uninitobj, bogus */
  uninitobj = new(object);
  set_bottom(uninitobj);
  bogus = new(object);
  set_bottom(bogus);
  
}


void
c_end_construct()
{
  void c_print_table();

/*
  c_print_table();
*/
  /* unless we've had a Stop_Now or Fatal error, we'll write some 
     output.  Would like a way to check max_error here, and only write
     if error <= Warning, but may have to move printerror to this 
     file to do that */
  if (name_table_size > 0)
    c_write_object(name_def_table[name_table_size-1].hermobj,
                   name_def_table[name_table_size-1].typename);
}


void
c_init_absprog()
{
    void init_printmap();
    void p_mod_import();

    init_printmap();		/* initialize the print mappings */
    init_links();

    Absprog = new_object();
    new_program(Absprog);	/* create an empty absprog */
    avl_new_table(Absprog@program__definitions_modules, firstelem_key);
				/* key = id */
    avl_new_table(Absprog@program__programs, firstelem_key); 
                /* key = id */
}


void
c_add_def(item_name, typenm, obj)
char *item_name;
objectp typenm;    /* predefined!typename */
objectp obj;
{

  if (obj isnt bogus) {
    /* this makes the (dangerous) assumption that item_name is allocated
       somewhere safe */
    name_def_table[name_table_size].name = item_name;
    name_def_table[name_table_size].typename = typenm;
    name_def_table[name_table_size].hermobj = obj;
    name_table_size++;
  }

}


objectp
c_lookup(typenm, item_name)
objectp typenm;        /* typename */
char *item_name;
{
  /* Note that this will return a copy of the most recent of possibly multiple
     definitions of item_name.  
  */

  int i;
  lobject(Eqflag);
  objectp newobj;

  for (i = name_table_size-1; i>=0; i--) {
    if (strcmp(item_name, name_def_table[i].name) is 0) {
      equal(Eqflag, typenm, name_def_table[i].typename);
      if (booleanval(Eqflag)) {
        newobj = new(object);
        set_bottom(newobj);
        copy(newobj, name_def_table[i].hermobj);
        return(newobj);
      }
      else {
        fe_error(LASTPHASE, errorcode__general_error,
                 "object %s has wrong type", item_name);
        return(bogus);
      }
    }
  }
  
  fe_error(LASTPHASE, errorcode__general_error,
           "object %s used but not defined", item_name);
  return(bogus);
}


objectp 
c_integer(typenm, value)
objectp typenm;      /* typename */
char *value;           /* string rep of integer */
{
  objectp newintp;
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification)
        isnt primitive_types__integertype) {
      fe_error(LASTPHASE, errorcode__general_error,
               "integer given for non-integer type");
      newintp = bogus;
    }
    else {
      newintp = new(object);
      set_bottom(newintp);
      if (ilit(newintp, atoi(value)) isnt Normal)
        fe_error(Fatal, errorcode__general_error,
                 "ilit failed for c_integer(%s)", value);
      /* NOTREACHED */
    }
  }
  else
    newintp = bogus;

  return(newintp);
}


objectp
c_real(typenm, value)
objectp typenm;       /* typename */
char *value;            /* string rep of double */
{
  objectp newobj;
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification)
        isnt primitive_types__realtype) {
      fe_error(LASTPHASE, errorcode__general_error,
               "real literal given for unreal type");
      newobj = bogus;
    }
    else {
/*
      newobj = new(object);
      set_bottom(newobj);
      rlit(newobj, atof(value));
*/    
      /* save the above until reals work */
      newobj = bogus;
    }
  }
  else
    newobj = bogus;

  return(newobj);
}


objectp
c_string(typenm, value)
objectp typenm;      /* typename */
char *value;           /* string */
{
  objectp newobj;
  lobject(Eqflag);

  if (typenm isnt bogus) {
    equal(Eqflag, typenm, PredefinedCharstring);
    if (booleanval(Eqflag)) {
      newobj = new(object);
      set_bottom(newobj);
      chs_lit(newobj, value);
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "string literal given for non-predefined!charstring type");
      newobj = bogus;
    }
  }
  else
    newobj = bogus;

  return (newobj);
}


objectp
c_unique(typenm)
objectp typenm;      /* typename */
{
  objectp newobj;
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification) isnt
        primitive_types__nominaltype) {
      fe_error(LASTPHASE, errorcode__general_error,
               "'unique' given for non-nominal type");
      newobj = bogus;
    }
    else {
      newobj = new(object);
      set_bottom(newobj);
      unique(newobj);
    }
  }
  else
    newobj = bogus;

  return(newobj);
}


objectp
c_new(typenm)
objectp typenm;      /* typename */
{
  objectp newobj;
  objectp c_new_record(), c_new_table();
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification) is
        primitive_types__recordtype) 
      newobj = c_new_record(typedefn);
    else if (obj_case_of(typedefn@type_definition__specification) is
        primitive_types__tabletype)
      newobj = c_new_table(typedefn);
    else if (obj_case_of(typedefn@type_definition__specification) is
        primitive_types__inporttype) {
      newobj = new(object);
      set_bottom(newobj);
      new_inport(newobj);
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "'new' given for non-newable type");
      newobj = bogus;
    }
  }
  else
    newobj = bogus;

  return(newobj);
}


objectp
c_typename_lit(typenm, value)
objectp typenm;        /* typename */
objectp value;           /* predefined!typename */
{
  lobject(Eqflag);

  if (typenm isnt bogus) {
    equal(Eqflag, typenm, PredefinedTypename);
    if (booleanval(Eqflag))
      return(value);
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "typename literal given for non-predefined!typename type");
      return(bogus);
    }
  }
  else
    return(bogus);
}


objectp
c_attributename_lit(typenm, value)
objectp typenm;        /* typename */
objectp value;           /* predefined!attributename */
{
  lobject(Eqflag);

  if (typenm isnt bogus) {
    equal(Eqflag, typenm, PredefinedAttributename);
    if (booleanval(Eqflag))
      return(value);
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "typename literal given for non-predefined!attributename type");
      return(bogus);
    }
  }
  else
    return(bogus);
}


objectp                  /* out integer for position of case_name */
c_init_variant(typenm, casenm)
objectp typenm;        /* typename */
char *casenm;            /* string rep of case */
{
  objectp newobj;       /* integer position for casenm */
  lobject(Name);         /* hermes object for casenm */
  lobject(Equalflag);        /* flag for equal() */
  objectp Enum;         /* the enumeration tagging this variant */
  objectp Evalues;      /* enumeration_values */
  int i;                
  lobject(Ename);        /* charstring */
  objectp typedefn;      /* type_definition */


  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification) isnt
        primitive_types__varianttype) {
      fe_error(LASTPHASE, errorcode__general_error,
               "variant case given for non-variant type");
      return(bogus);
    }
    else {
      newobj = new(object);
      set_bottom(newobj);
      
      chs_lit(Name, casenm);
      Enum = lookup_typename(typedefn@type_definition__specification@Component@variant_info__case_type);
      Evalues = Enum@type_definition__specification@Component@enumeration_info__values;

      for (i=0; i < obj_size_of(Evalues); i++) {
        ilit(newobj, i);
        lookup_at(Ename, Evalues, newobj);
        equal(Equalflag, Ename, Name);
        if (booleanval(Equalflag)) {
          return(newobj);
          /* NOTREACHED */
        }
      }
      fe_error(LASTPHASE, errorcode__general_error,
               "case name does not correspond to any variant case");
      return(bogus);
    }
  }
  else
    return(bogus);
}


objectp
c_get_case_type(typenm, caseid)
objectp typenm;         /* typename */
objectp caseid;         /* integer */
{
  lobject(Pinfo);          /* partition_info */
  lobject(Cdecl);
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus and caseid isnt bogus) {
    typedefn = lookup_typename(typenm);
    /* warning: this is really dumb, but there is no easy way to specify
       which key we want to use */
    if (partition_info__case_id is 0) {
      if (h_lookup(Pinfo,
                   typedefn@type_definition__specification@Component@variant_info__case_mapping,
                   caseid)
          is NotFound) {
        fe_error(LASTPHASE, errorcode__general_error,
                 "problems in c_get_case_type h_lookup, mate");
        return(bogus);
      }
    }
    else if (partition_info__case_id is 1) {
      if (h_lookup_secondary(Pinfo,
                             typedefn@type_definition__specification@Component@variant_info__case_mapping,
                             caseid)
          is NotFound) {
        fe_error(LASTPHASE, errorcode__general_error,
                 "problems in c_get_case_type h_lookup_secondary, mate");
        return(bogus);
      }
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "problems in c_get_case_type - key num too big");
      return(bogus);
    }
    
    if (h_lookup(Cdecl,
                 typedefn@type_definition__component_declarations,
                 Pinfo@partition_info__component_id)
        is NotFound) {
      fe_error(LASTPHASE, errorcode__general_error,
               "problems in c_get_case_type h_lookup 2 , mate");
      return(bogus);
    }

    /* Hmm, Cdecl is a pointer to a local variable, but hopefully
       the following will work */
    return(Cdecl@component_declaration__type);
  }
  else
    return(bogus);
}


objectp                 /* formal_typestate */
c_get_case_typestate(typenm, caseid)
objectp typenm;         /* typename */
objectp caseid;         /* integer */
{
  lobject(Pinfo);          /* partition_info */
  objectp typedefn;      /* type_definition */

  /* this follows the outline of c_get_case_type, except it assumes
     no errors will occur (since they already would have happened in
     c_get_case_type).
     */

  typedefn = lookup_typename(typenm);
  /* warning: this is really dumb, but there is no easy way to specify
     which key we want to use */
  if (partition_info__case_id is 0) {
    h_lookup(Pinfo,
             typedefn@type_definition__specification@Component@variant_info__case_mapping,
             caseid);
    }
  else {
    h_lookup_secondary(Pinfo,
                       typedefn@type_definition__specification@Component@variant_info__case_mapping,
                       caseid);
    }
  
  return(Pinfo@partition_info__case_typestate);

}


objectp
c_unite_variant(typenm, caseid, expr)
objectp typenm;       /* typename */
objectp caseid;         /* integer */
objectp expr;           /* expression value */
{
  objectp newobj;
  flag c_fix_typestate();
  objectp c_get_case_type(), c_get_case_typestate();

  if (typenm isnt bogus and caseid isnt bogus 
      and expr isnt bogus) {  

    /* I know, it's inefficient to call all these c_get's multiple times;
       should rewrite this someday.
       */
    if (c_fix_typestate(c_get_case_type(typenm, caseid),
                        expr,
                        c_get_case_typestate(typenm, caseid),
                        nil_false)) {
      newobj = new(object);
      set_bottom(newobj);
      unite(newobj, expr, integerval(caseid));
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "variant object not at least case_typestate");
      newobj = bogus;
    }
  }
  else /* propagate bogosity */
    newobj = bogus;

  return(newobj);
}


objectp
c_named_lit(typenm, value)
objectp typenm;        /* typename */
char *value;             /* string rep of case */
{
  objectp newobj;
  lobject(Name);         /* hermes object for value */
  lobject(Equalflag);        /* flag for equal() */
  objectp Evalues;      /* enumeration_values */
  lobject(Epos);         /* position in Evalues table */
  int i;                /* ditto, but in C format */
  lobject(Ename);        /* charstring */
  objectp typedefn;      /* type_definition */
  int found = 0;

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification) is
        primitive_types__booleantype) {

      newobj = new(object);
      set_bottom(newobj);

      chs_lit(Name, value);

      equal(Equalflag, Name, typedefn@type_definition__specification@Component@boolean_info__true_name);
      if (booleanval(Equalflag)) {
        h_boolean(newobj, nil_true);
      }
      else {
        equal(Equalflag, Name, typedefn@type_definition__specification@Component@boolean_info__false_name);
        if (booleanval(Equalflag)) {
          h_boolean(newobj, nil_false);
        }
        else {
          fe_error(LASTPHASE, errorcode__general_error,
                   "named boolean literal does not correspond to either case");
          newobj = bogus;
        }
      }
    }
    else if (obj_case_of(typedefn@type_definition__specification) is
        primitive_types__enumerationtype) {
      newobj = new(object);
      set_bottom(newobj);

      chs_lit(Name, value);
      Evalues = typedefn@type_definition__specification@Component@enumeration_info__values;

      for (i=0; i < obj_size_of(Evalues); i++) {
        ilit(Epos, i);
        lookup_at(Ename, Evalues, Epos);
        equal(Equalflag, Ename, Name);
        if (booleanval(Equalflag)) {
          if (booleanval(typedefn@type_definition__specification@Component@enumeration_info__ordered))
            ordenum_lit(newobj, i);
          else
            enum_lit(newobj, i);
          found = 1;
          break;
        }
      }
      if (not found) {
        fe_error(LASTPHASE, errorcode__general_error,
                 "named enumeration literal does not correspond to any case");
        newobj = bogus;
      }
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "named literal given for non-{boolean, enumeration} type");
      newobj = bogus;
    }
  }
  else
    newobj = bogus;

  return(newobj);
}


objectp
c_new_record(typedefn)
objectp typedefn;     /* type_definition */
{
  objectp newobj;

  newobj = new(object);
  set_bottom(newobj);
  
  _qh.val.integer = 
    obj_size_of(typedefn@type_definition__component_declarations);
  h_qcall(o_new_record, _qh, newobj,0);

  return (newobj);
}


recordtable_info
c_init_rectab(typenm)
objectp typenm;      /* typename of record or table */
{
  recordtable_info newrectab;
  objectp c_new_record(), c_new_table();
  objectp typedefn;      /* type_definition */

  newrectab.size = 0;

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification) 
        is primitive_types__recordtype) {
      newrectab.obj = c_new_record(typedefn);
    }
    else if (obj_case_of(typedefn@type_definition__specification) 
             is primitive_types__tabletype) {
      newrectab.obj = c_new_table(typedefn);
    }
    else {
      fe_error(LASTPHASE, errorcode__general_error,
               "element list given for non-record and non-table type");
      newrectab.obj = bogus;
    }
  }
  else {
    /* propagate bogosity */
    newrectab.obj = bogus;
  }

  /* newrectab bogus if rt_obj is, or rt_obj not record or table */
  return(newrectab);
}


objectp
c_end_rectab(typenm, rectab)
objectp typenm;        /* typename of record or table we're in */
recordtable_info rectab;
{
  objectp typedefn;      /* type_definition */

  if (rectab.obj isnt bogus) { /* NB: typenm is bogus => rectab.obj is bogus */
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification)
        is primitive_types__recordtype) {
      if (rectab.size <
          obj_size_of(typedefn@type_definition__component_declarations))
        fe_error(LASTPHASE, errorcode__general_error,
                 "too few components given for record; remainder left uninit");
    }
    else {  /* must be table; otherwise would be bogus */
      /* not much to do here */
    }
  }

  return(rectab.obj);
}


objectp
c_get_typename(typenm, pos)
objectp typenm;      /* typename of record or table */
int pos;               /* position of component or element */
/* result bogus if typenm is, if typenm not table or record, or
   if pos is too big for record */
{
  objectp c_get_typename_from_position();
  objectp typedefn;      /* type_definition */

  if (typenm isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification)
        is primitive_types__recordtype) {
      return(c_get_typename_from_position(typedefn, pos));
    }
    else if (obj_case_of(typedefn@type_definition__specification)
        is primitive_types__tabletype) {
      return(typedefn@type_definition__specification@Component@table_info__element_type);
    }
    else {
      /* type error, but message already generated by c_init_rectab */
      return(bogus);
    }
  }
  else {
    /* propagate bogosity */
    return(bogus);
  }
  /*NOTREACHED*/
}



objectp  /* out typename of componentpos'th component */
c_get_typename_from_position(typedefn, componentpos)
objectp typedefn;       /* type_definition of record */
int componentpos;      /* position of component */
/* result is bogus if componentpos too big for record */
{
  objectp newobj;     /* typename */
  lobject(Cpos);      /* integer */
  lobject(Cdecl);     /* temporary component_declaration */

  ilit(Cpos, componentpos);

  if (lookup_at(Cdecl,
                typedefn@type_definition__component_declarations,
                Cpos)
         is NotFound) {
    fe_error(LASTPHASE, errorcode__general_error,
             "more components given for record than exist in definition");
    newobj = bogus;
  }
  else
    newobj = Cdecl@component_declaration__type;

  return(newobj);
}



recordtable_info
c_add_to_rectab(typenm, rectab, component)
objectp typenm;        /* typename of record or table we're in */
recordtable_info rectab;
objectp component;       /* arbitrary object */
{
  objectp typedefn;      /* type_definition */
  flag c_fix_typestate();

  if (rectab.obj isnt bogus) {
    typedefn = lookup_typename(typenm);
    if (obj_case_of(typedefn@type_definition__specification)
        is primitive_types__recordtype) {
      if (rectab.size >= 
          obj_size_of(typedefn@type_definition__component_declarations))
        fe_error(Information, errorcode__general_error,
                 "extra component for record being ignored");
      else {
        if (component is bogus)
          fe_error(Information, errorcode__general_error,
                   "bogus component in record left uninitialized");
        else
          /* '*rectab.obj@rectab.size = *component' may work, but may be too 
             macro dependent */
          rectab.obj->value.record->data[rectab.size] = *component;
        rectab.size++;
      }
    }
    else {  
      if (component is bogus)
        fe_error(Information, errorcode__general_error,
                 "bogus entry not added to table");
      else {
        if (c_fix_typestate(typedefn@type_definition__specification@Component@table_info__element_type,
                            component,
                            typedefn@type_definition__specification@Component@table_info__element_typestate,
                            nil_true)) {

          /* Since c_fix_typestate is NYI, at least notify if
             component is completely uninit */
          if (component is uninitobj)
            fe_error(Information, errorcode__general_error,
                     "WARNING:  uninitialized entry being added to table.  Are you sure you want to do this?");
          
          /* all previously stored objects are copied on lookup, so
             I don't need to worry about this insert wiping out rectab.obj */
          if (insert(rectab.obj, component) is DuplicateKey)
            fe_error(LASTPHASE, errorcode__general_error,
                     "duplicate key in table entry; bad entry not added");
          else
            /* yea, we could have a Depletion exception here, but so what? */
            rectab.size++;
        }
        else
            fe_error(LASTPHASE, errorcode__general_error,
                     "typestate error in table entry; bad entry not added");
      }
    }
  }

  return(rectab);
}


flag
c_fix_typestate(typenm, entry, formts, modify)
objectp typenm;        /* typename of entry */
objectp entry;         /* arbitrary object */
objectp formts;        /* formal_typestate */
flag modify;
{
  /* If typestate of entry is lower than formts, return false.
     Otherwise, we will return true.  In this case, if modify is true we
     lower the typestate of entry to be formts.
     */
  /* Not Yet Implemented */

  return(nil_true);
}


void
c_print_table()
{
  int i;

  for (i=0; i<name_table_size; i++) 
    c_print_table_entry(i);
}


c_print_table_entry(pos)
int pos;
{
  lobject(Varname);

  chs_lit(Varname, name_def_table[pos].name);
  print(Varname);
  print(name_def_table[pos].hermobj);
}


c_write_object(hermobj, typenm)
objectp hermobj;
objectp typenm;
{
  lobject(CFilenameout);   /* charstring */ 
  lobject(CFilesuffix);    /* charstring */
  lobject(Pi);             /* polymorph_info */
  objectp formts;          /* formal_typestate */
  objectp wrappedobj;      /* polymorph */

  objectp c_new_table();
  char *get_srcfile_name(), *rindex();
  char *fullfname, *fname, *fsuffix;

  fullfname = get_srcfile_name();
  fname = rindex(fullfname,'/');
  if (fname isnt nil)
    fname = fname+1;
  else
    fname = fullfname;
  fsuffix = rindex(fname, '.');
  if (fsuffix is nil)
    fsuffix = fname+strlen(fname);
  *fsuffix = nil;   /* end string here (chs_lit expects null terminator) */

  chs_lit(CFilenameout, fname);
  chs_lit(CFilesuffix, ".ho");

  merge(CFilenameout, CFilesuffix);

  /* now we make hermobj into a polymorph before writing */ 
  new_record(Pi, polymorph_info);

  copy(Pi@polymorph_info__type, typenm);

  /* just stick in empty typestate for now */
  formts = c_new_table(lookup_typename(PredefinedFormalTypestate));
  move(Pi@polymorph_info__typestate, formts);

  /* I have no idea whether this is really necessary */
  wrappedobj = new(object);
  set_bottom(wrappedobj);

  wrap(wrappedobj, hermobj, Pi->value.record);

  if (write(wrappedobj, CFilenameout) isnt Normal)
    fe_error(LASTPHASE, errorcode__general_error,
             "Can't write hermes object file '%s'",
             stringval(CFilenameout));
}
  

objectp
c_new_table(typedefn)
objectp typedefn;      /* type_definition */
{
  /* Note: these are the current definitions of the following macros from
     ../codegen/codegen.h .  If they change there, they must be separately
     updated here.
     */
#define SIZE_OF_CHARS	256
#define INITSIZE_CHAR	80
#define GROWTH_CHAR	256
#define INITSIZE_VEC	8
#define GROWTH_VEC	64

  objectp newobj;
  lobject(Newtableinfo);  

  objectp tableinfo;     /* table_info */
  objectp tdef;          /* type_definition */
  lobject(Empty);        /* empty */
  lobject(Itmp);         /* integer */

  flag exitvector;

  /* unite _qh.val from newTableInfo(
     tdef.specification.table_info,
     FNS.typeDef,
     FNS.compOffsets */

  set_bottom(Empty);
  new_record(Newtableinfo, new_table_info);
  tableinfo = typedefn@type_definition__specification@Component;
      
  /* get *Newtableinfo == hermes object of type interpform!new_table_info,
     as returned by 
     newTableInfo(tableinfo, ...)
     */
  /* from here on is basically the hermes process 'newtableinfo'
     translated to C-hermes */
  
  /* -- allocate the result and get the element type */
  tdef = lookup_typename(tableinfo@table_info__element_type);
  
  /* -- Decide on the primary representation first... */

  /* -- ordered tables get vector-like representations */

  if (booleanval(tableinfo@table_info__ordered_table)) {
    lobject(Ip);

    new_record(Ip, integer_pair);

    exitvector = nil_false;
    if (obj_case_of(tdef@type_definition__specification) is
        primitive_types__enumerationtype) {
      if (obj_size_of(tdef@type_definition__specification@Component@enumeration_info__values)
          <= SIZE_OF_CHARS) {
        ilit(Itmp, INITSIZE_CHAR);
        move(Ip@integer_pair__int_one, Itmp);
        ilit(Itmp, GROWTH_CHAR);
        move(Ip@integer_pair__int_two, Itmp);
        unite(Newtableinfo@new_table_info__nonlookup, Ip,
              table_rep_type__charstring);
      }
      else {
        /* exit vector */
        exitvector = nil_true;
      }
    }
    else {
      /* exit vector */
      exitvector = nil_true;
    }

    if (exitvector) {  /* on exit(vector) */
      ilit(Itmp, INITSIZE_VEC);
      move(Ip@integer_pair__int_one, Itmp);
      ilit(Itmp, GROWTH_VEC);
      move(Ip@integer_pair__int_two, Itmp);
      unite(Newtableinfo@new_table_info__nonlookup, Ip,
            table_rep_type__vector);
    }
  }
  else {
    /* -- unordered table... no primary representation if there are keys, */
    /* -- else use a linked list */
    if (obj_size_of(tableinfo@table_info__keys) is 0) {
      unite(Newtableinfo@new_table_info__nonlookup, Empty,
            table_rep_type__linklist);
    }
    else {
      unite(Newtableinfo@new_table_info__nonlookup, Empty,
            table_rep_type__none);
    }
  }

  if (obj_size_of(tableinfo@table_info__keys) is 0) {
    unite(Newtableinfo@new_table_info__opt_reps, Empty,
          option__absent);
  }
  else {
    /* -- Now allocate a representation for each key (NYI: and index) */
    lobject(Li);
    lobject(Rep);
    lobject(LiKey);

    int i;              /* counter for looping over keys */
    lobject(Kpos);      /* hermes integer for position i */
    lobject(Key);       /* formal_object */
    int j;              /* counter for looping over components of keys */
    lobject(Cpos);      /* hermes integer for position j */
    lobject(Components); /* component_list */ 
    objectp operand;    /* interpform!operand */
    void c_pseudo_new_unkeyed_table();
    objectp c_compOffsets();
    
    new_record(Li, lookup_info);

    /* interpform!table_rep_list is ordered, not charstring repr. */
    c_pseudo_new_unkeyed_table(Li@lookup_info__reps, nil_true, nil_false);
    /* interpform!lookupset is ordered, not charstring representation */
    c_pseudo_new_unkeyed_table(Li@lookup_info__keys, nil_true, nil_false);
    c_pseudo_new_unkeyed_table(Li@lookup_info__indices, nil_true, nil_false);

    for(i = 0; i<obj_size_of(tableinfo@table_info__keys); i++) {
      ilit(Kpos, i);
      lookup_at(Key, tableinfo@table_info__keys, Kpos);

      set_bottom(Rep);
      unite(Rep, Empty, table_rep_type__keyavl);
      insert(Li@lookup_info__reps, Rep);

      /* -- accumulate offset lists for the key components */
      /* interpform!operand_list is ordered, not charstring repr. */
      c_pseudo_new_unkeyed_table(LiKey, nil_true, nil_false);
      
      for (j=0; j<obj_size_of(Key); j++) {
        ilit(Cpos, j);
        lookup_at(Components, Key, Cpos);

        /* block declare
             type: typename;
           begin
             type := args.info.element_type;
             insert interpform!operand#(args.compOffsets(type,components)) 
               into LiKey;
           end block;
        */
        operand = c_compOffsets(tableinfo@table_info__element_type,
                                Components);
        insert(LiKey, operand);

      }

      insert(Li@lookup_info__keys, LiKey);
    }


    /* -- Code to generate datareps for indices should go here... */

    /* if B(I(size of li.reps) <> ZERO) then */
    unite(Newtableinfo@new_table_info__opt_reps, Li,
          option__present);
  }

  /* I'm going to assume that o_new_table leaves the qualifier
     constant, and creates no pointers into it.  Thus, the qualifier
     may point to the local variable Newtableinfo (which points to other
     local variables, etc.). */
  newobj = new(object);
  set_bottom(newobj);

  _qh.val.record = Newtableinfo->value.record;
  h_qcall(o_new_table, _qh, newobj, 0);

  return(newobj);
}


void
c_pseudo_new_unkeyed_table(dst, ordered, charstringrep)
objectp dst;
flag ordered;
flag charstringrep;
{
  /* 
     This is like c_new_record, only it places the result in 'dst', and 
     does not refer to the type_definition of the table we're creating.  
     Instead, this assumes that the 
     table has no keys, and the flags 'ordered' and 'charstringrep' 
     tell us whether the table is ordered and if it should get the
     charstring representation, respectively.  Obviously, if you get the
     flags wrong for the type you have in mind, big problems could result.
     */

  lobject(Newtableinfo);  
  lobject(Empty);        /* empty */
  lobject(Itmp);         /* integer */

  set_bottom(Empty);
  new_record(Newtableinfo, new_table_info);


  if (ordered) {
    lobject(Ip);

    new_record(Ip, integer_pair);

    /* charstringrep should only be true if 
       obj_case_of(element_type.specification) = 'enumerationtype', and 
       obj_size_of(element_type.specification.enumeration_info.values) 
       < SIZE_OF_CHARS.
       */
    if (charstringrep) {
      ilit(Itmp, INITSIZE_CHAR);
      move(Ip@integer_pair__int_one, Itmp);
      ilit(Itmp, GROWTH_CHAR);
      move(Ip@integer_pair__int_two, Itmp);
      unite(Newtableinfo@new_table_info__nonlookup, Ip,
            table_rep_type__charstring);
    }
    else { /* on exit(vector) */
      ilit(Itmp, INITSIZE_VEC);
      move(Ip@integer_pair__int_one, Itmp);
      ilit(Itmp, GROWTH_VEC);
      move(Ip@integer_pair__int_two, Itmp);
      unite(Newtableinfo@new_table_info__nonlookup, Ip,
            table_rep_type__vector);
    }
  }
  else {
    /* -- unordered table... no primary representation if there are keys, */
    /* -- else use a linked list */
   
    /* size_of(table_info.keys) must be ZERO here */ 
    unite(Newtableinfo@new_table_info__nonlookup, Empty,
          table_rep_type__linklist);
  }

  /* size_of(table_info.keys) must be 0 here */ 
  unite(Newtableinfo@new_table_info__opt_reps, Empty,
        option__absent);

  /* -- All done with newTableInfo ... */

  /* unite _qh.val from newTableInfo(
     tdef.specification.table_info,
     FNS.typeDef,
     FNS.compOffsets */

  _qh.val.record = Newtableinfo->value.record;
  h_qcall(o_new_table, _qh, dst, 0);
}


objectp             /* interpform!operand */
c_compOffsets(type, components)
objectp type;       /* typename */
objectp components; /* component_list */
{
  objectp newobj;  /* interpform!operand */
  int i;           /* counter for looping over components */
  lobject(Cpos);   /* hermes integer for i */
  lobject(Comp);   /* componentid */
  objectp tdef;    /* type_definition */
  objectp component; /* component_declaration */
  lobject(Offset); /* integer */
  void c_pseudo_new_unkeyed_table();
  objectp lookup_component_declaration();

  newobj = new(object);
  set_bottom(newobj);

  /* interpform!operand is ordered, not charstring */
  c_pseudo_new_unkeyed_table(newobj, nil_true, nil_false);

  for (i=0; i<obj_size_of(components); i++) {
    ilit(Cpos, i);
    lookup_at(Comp, components, Cpos);
    
    tdef = lookup_typename(type);
    component = lookup_component_declaration(type, Comp);

    set_bottom(Offset);
    if (obj_case_of(tdef@type_definition__specification) is
        primitive_types__varianttype) {
      ilit(Offset, 0);
    }
    else {
      scan_position(Offset, component, tdef@type_definition__component_declarations);
    }

    insert(newobj, Offset);
    type = component@component_declaration__type;
      
  }

  return(newobj);

}
