-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disqualifier: using(predefined,interpform,disassembler,common,disinternal)
  process (Q: disqualifierQ)
  declare
    args: disqualifier;
    string: charstring;
  begin
    receive args from Q;
    -- print charstring#"Printing a qualifier.";
    -- print args.qualifier;
    new string;
    select case of args.qualifier
      where ('absent')
	-- empty string
      where ('boolean')
	-- represent truth with "true", falsehood with "false"
	reveal args.qualifier.boolean;
	if args.qualifier.boolean
	  then
	    merge "true" into string;
	  else
	    merge "false" into string;
	  end if;
      where ('integer')
	-- represent integers in signed decimal
	reveal args.qualifier.integer;
	block
	  declare
	    label: boolean;
	  begin
	    select args.context
	      where ('get_or_goto')
		label <- 'true';
	      where ('idxfind_or_goto')
		label <- 'true';
	      where ('branch')
		label <- 'true';
	      where ('branch_false')
		label <- 'true';
	      where ('branch_true')
		label <- 'true';
	      otherwise
		label <- 'false';
	      end select;
	    if label
	      then
		block begin
		    insert copy of args.qualifier.integer
		       into args.dis.label.dests;
		  on (DuplicateKey)
		  end block;
		merge copy of args.dis.label.label_base
		   into string;
	      else
	      end if;
	    merge args.dis.integer(args.qualifier.integer) 
	       into string;
	  end block;
      where ('real')
	print charstring#"real qualifiers are unsupported.";
	exit Unsupported;
      where ('string')
	reveal args.qualifier.string;
	insert '"' into string;
	for c in args.qualifier.string[]
	  inspect
	    if c = '"'
	      then
		insert '"' into string;
	      else
	      end if;
	    insert copy of c into string;
	  end for;
	insert '"' into string;
      where ('integer_pair')
	reveal args.qualifier.integer_pair;
	-- string representation depends on context
	block
	  declare
	    temp: interpform!qualifier;
	    first: boolean;
	    second: boolean;
	  begin
	    select args.context
	      where ('oeloop')
		first <- 'true';
		second <- 'false';
	      where ('find_or_goto')
		first <- 'false';
		second <- 'true';
	      otherwise
		first <- 'false';
		second <- 'false';
	      end select;
	    merge "pair " into string;
	    if first
	      then
		-- the first element is really a label
		unite temp.integer 
		    from copy of args.qualifier.integer_pair.int_one;
		merge args.dis.qualifier
		    (args.dis,temp,'branch',args.procnames) into string;
	      else
		merge args.dis.integer(args.qualifier.integer_pair.int_one)
		   into string;
	      end if;
	    insert ' ' into string;
	    if second
	      then
		-- the second element is really a label
		unite temp.integer 
		    from copy of args.qualifier.integer_pair.int_two;
		merge args.dis.qualifier
		    (args.dis,temp,'branch',args.procnames) into string;
	      else
		merge args.dis.integer(args.qualifier.integer_pair.int_two)
		   into string;
	      end if;
	  end block;
      where ('polymorph_info')
	reveal args.qualifier.polymorph;
	block
	  declare
	    temp: interpform!qualifier;
	  begin
	    merge "wrapper " into string;
	    unite temp.typename
	       from copy of args.qualifier.polymorph.type;
	    merge args.dis.qualifier(args.dis,temp,'noop',args.procnames)
	       into string;
	    merge ", emptyts" into string;
	  end block;
      where ('program')
	-- The qualifier is a process id, which we translate into the
	-- name chosen at top-level
	reveal args.qualifier.program;
	block begin
	  inspect p in args.procnames[args.qualifier.program] begin
	    string <- "process " | p.name;
	  end inspect;
	end block;

      where ('code')
	exit Unsupported;

      where ('exception')
	reveal args.qualifier.exception;
	-- first part on the exception is a typename
	if args.context='noop'
	  then
	  else
	    merge "exception " 
	       into string;
	  end if;
	block
	  declare
	    temp: interpform!qualifier;
	  begin
	    unite temp.typename 
	       from copy of args.qualifier.exception.type;
	    merge args.dis.qualifier(args.dis,temp,'noop',args.procnames)
	       into string;
	    insert '.' into string;
	    inspect module 
		in args.dis.pms.defs
		   [args.qualifier.exception.type.moduleid]
	      begin
		inspect exception in module.exceptions where
		      (exception.type = args.qualifier.exception.type.typeid
			and exception.exception = args.qualifier.exception.exceptionid)
		  begin
		    merge copy of exception.name into string;
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Exception not found.";
	  end block;
      where ('typename')
	if args.context <> 'noop'
	  then
	    merge "typeid " into string;
	  else
	  end if;
	reveal args.qualifier.typename;
	block
	  begin
	    inspect module 
		in args.dis.pms.defs[args.qualifier.typename.moduleid]
	      begin
		merge copy of module.name into string;
		insert '!' into string;
		inspect type in module.types
		       where (type.id=args.qualifier.typename.typeid)
		  begin
		    merge copy of type.name into string;
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Typename not found.";
	  end block;
      where ('block')
	-- handler list
	reveal args.qualifier.block;
	block
	  declare
	    first: boolean;
	  begin
	    merge "handlers " into string;
	    first <- 'true';
	    for handler in args.qualifier.block[] 
	      inspect
		if first
		  then
		    first <- 'false';
		  else
		    insert ' ' into string;
		    insert ',' into string;
		  end if;
		block
		  declare
		    temp: interpform!qualifier;
		    s: charstring;
		  begin
		    select case of handler.handler
		      where ('builtin')
			reveal handler.handler.builtin;
			select handler.handler.builtin
			  where('CaseError')
			    s <- "CaseError";
			  where('ConstraintError')
			    s <- "ConstraintError";
			  where('ConstraintFailure')
			    s <- "ConstraintFailure";
			  where('Depletion')
			    s <- "Depletion";
			  where('Disconnected')
			    s <- "Disconnected";
			  where('DivideByZero')
			    s <- "DivideByZero";
			  where('DuplicateKey')
			    s <- "DuplicateKey";
			  where('InterfaceMismatch')
			    s <- "InterfaceMismatch";
			  where('NotFound')
			    s <- "NotFound";
			  where('PolymorphMismatch')
			    s <- "PolymorphMismatch";
			  where('DefinitionError')
			    s <- "DefinitionError";
			  where('RangeError')
			    s <- "RangeError";
			  where('Uncopyable')
			    s <- "Uncopyable";
			  otherwise
			    print charstring#"Unknown builtin exception";
			    exit Unsupported;
			  end select;
		      where ('user')
			reveal handler.handler.user;
			unite temp.exception 
			    from copy of handler.handler.user;
			s <- args.dis.qualifier
			    (args.dis,temp,'noop',args.procnames);
		      where ('exit')
			reveal handler.handler.exit;
			unite temp.exit 
			    from copy of handler.handler.exit;
			s <- args.dis.qualifier
			    (args.dis,temp,'branch',args.procnames);
		      where ('others')
			reveal handler.handler.others;
			s <- "others";
		      otherwise
			s <- "Unknown exception";
		      end select;
		    merge s into string;
		    insert ' ' into string;
		    unite temp.integer from copy of handler.label;
		    merge args.dis.qualifier
			(args.dis,temp,'branch',args.procnames) into string;
		  end block;
	      end for;
	    insert ';' into string;
	  end block;
      where ('exit')
	reveal args.qualifier.exit;
	merge "exitid " into string;
	block begin
	    inspect module 
		in args.dis.pms.execs[args.dis.pms.progid]
	      begin
		inspect exitmap
		    in module.exits
		       where (args.qualifier.exit=exitmap.exit)
		  begin
		    merge copy of exitmap.name
		       into string;
		  end inspect;
	      end inspect;
	  on (NotFound)
	    print charstring#"Exit not found.";
	    block
	      declare
		rec: exit_printrec;
		name: charstring;
	      begin
		inspect exitmap in args.dis.label.exits 
		       where (args.qualifier.exit=exitmap.exit)
		  begin 
		    name := exitmap.name;
		    merge name into string;
		  end inspect;
	      on (NotFound)
		new rec;
		rec.exit := args.qualifier.exit;
		name := args.dis.label.label_base;
		merge "_exit" into name;
		merge 
		   args.dis.integer(size of args.dis.label.exits)
		   into name;
		rec.name := name;
		insert rec into args.dis.label.exits;
		merge name into string;
	      end block;
	  end block;
      where ('select')
	reveal args.qualifier.select;
	-- print out a ' ' seperated list of labels
	merge "selectarms " into string;
	block
	  declare
	    temp: interpform!qualifier;
	  begin
	    for label in args.qualifier.select[]
	      inspect
		unite temp.integer from copy of label;
		merge args.dis.qualifier
		    (args.dis,temp,'branch',args.procnames) into string;
		insert ' ' into string;
	      end for;
	  end block;
	insert ';' into string;
      where ('new_table')
	reveal args.qualifier.new_table;
	block
	  declare
	    temp: interpform!qualifier;
	    first: boolean;
	  begin
	    merge "table " into string;
	    -- optional primary representation
	    select case of args.qualifier.new_table.nonlookup
	      where ('none')
	      where ('vector')
		merge args.dis.integer(1)
		   into string;
		insert ' ' into string;
	      where ('charstring')
		merge args.dis.integer(2)
		   into string;
		insert ' ' into string;
	      where ('linklist')
		merge args.dis.integer(9)
		   into string;
		insert ' ' into string;
	      otherwise
		print charstring#"Unknown primary rep. in new_table_info.";
		exit Unsupported;
	      end select;
	    -- optional lookup_info
	    if (case of args.qualifier.new_table.opt_reps = 'present')
	      then
		reveal args.qualifier.new_table.opt_reps.info;
		-- first list: reps
		first <- 'true';
		insert '(' into string;
		for rep in args.qualifier.new_table.opt_reps.info.reps[]
		  inspect
		    if first
		      then
			first <- 'false';
		      else
			insert ',' into string;
		      end if;
		    merge args.dis.integer (
			evaluate number:integer from
			    select case of rep
			      where ('none')
				number <- 0;
			      where ('vector')
				number <- 1;
			      where ('charstring')
				number <- 2;
			      where ('dublink')
				number <- 3;
			      where ('keyavl')
				number <- 4;
			      where ('keyhash')
				number <- 5;
			      where ('bitset')
				number <- 6;
			      where ('indexavl')
				number <- 7;
			      where ('indexhash')
				number <- 8;
			      where ('linklist')
				number <- 9;
			      otherwise
				print charstring#"Unknown table_rep_type.";
				exit Unsupported;
			      end select;
			  end
		      )
		       --(convert of (case of rep))
		       into string;
		  end for;
		insert ')' into string;
		insert ' ' into string;
		-- second list: keys
		insert '(' into string;
		first := 'true';
		for key in args.qualifier.new_table.opt_reps.info.keys[]
		  inspect
		    if first
		      then
			first := 'false';
		      else
			insert ',' into string;
		      end if;
		    for op in key[]
		      inspect
			merge args.dis.operand(args.dis,op)
			   into string;
			insert ' ' into string;
		      end for;
		  end for;
		insert ')' into string;
		insert ' ' into string;
		-- third list: indices
		insert '(' into string;
		first := 'true';
		for indice in args.qualifier.new_table.opt_reps.info.indices[]
		  inspect
		    if first
		      then
			first := 'false';
		      else
			insert ',' into string;
		      end if;
		    for op in indice[]
		      inspect
			merge args.dis.operand(args.dis,op)
			   into string;
			insert ' ' into string;
		      end for;
		  end for;
		insert ')' into string;
	      else
	      end if;
	  end block;
      where ('attributename')
	print charstring#"attributename qualifiers are unsupported.";
	exit Unsupported;
      otherwise
	print charstring#"unknown qualifier sent to disqualifier.";
	exit Unsupported;
      end select;
    -- print string;
    args.rep <- string;
    return args;
  on exit (Unsupported)
    return args exception Unsupported;
  on (disqualifier.Unsupported,disoperation.Unsupported,disopcode.Unsupported)
    return args exception Unsupported;
  end process
