-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)backpatch.d	1.2 3/13/90

backpatch: using (predefined) definitions

-- types and their dependents (components and named literals in variant defs)

unres_types: table of unres_type { full }
	keys (typeid) (name);

unres_type: record (
	typeid: predefined!typeid,
	name: predefined!charstring,
	dependents: unres_dependents,
	lineno: integer );


dependent_type: enumeration ( 'unknown', 'component', 'named literal' );

unres_dependents: variant of dependent_type (
	'unknown' -> empty: empty {},
	'named literal' -> literals: literal_info { full },
	'component' -> components: unres_components { full } );

literal_info: record (
	nextid: predefined!integer,
	literals: unres_literals );

unres_literals: table of unres_literal { full }
	keys (id) (name);

unres_literal: record (
	id: predefined!integer,
	name: predefined!charstring );

unres_components: table of unres_component { full }
	keys (id) (name);

unres_component: record (
	id: predefined!componentid,
	name: predefined!charstring,
	occurences: comp_occurrences );

comp_occurrences: table of comp_occurrence { full };

comp_occurrence: record (
	unresolved: /* pointer to */ component_list,
	dependent_components: string_list );

string_list: ordered table of predefined!charstring { full };


-- attributes

unres_attributes: table of unres_attribute { full }
	keys (name);

unres_attribute: record 
(
	name: predefined!charstring,
	id: attributeid
);

-- for associations, need to keep variant-like forward definitions of
--  attribute parameter names.  not in v0.


-- also need exception names, but we won't do them in v0.


end definitions
