/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: links.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)links.ch	1.11 2/17/92";
#endif


#include "cherm.h"
#include "resolve.h"

#include "predefined.cd"
#include "parse.cd"
#include "errors.cd"

static objectp LinknameSet;
static objectp Links;

void
init_links()
{
    LinknameSet = new_object();
    Links = new_object();

    avl_new_table(LinknameSet, whole_key);
    avl2_new_table(Links, firstandsecond_keyset);
}


objectp
get_links()
{
    discard(LinknameSet);
    return(Links);
}


static objectp
read_filed_proc(Name)
objectp Name;			/* constant chs_table */
{
  objectp io_read_proc();

  return(io_read_proc(Name));
}


void 
p_load_link(name)
char *name;
{
    char *hermlpath();

    objectp poFile;
    lobject(LinkedProg);
    lobject(Junk);
    lobject(Modulename);

    chs_lit(Modulename, name);
    if (insert(LinknameSet, Modulename) is DuplicateKey) {
	discard(Modulename);
	return;
    }


    poFile = read_filed_proc(Modulename);

    if (poFile) {
      new_record(LinkedProg, linkedprogram);
      copy(LinkedProg@Id, poFile@program__main_program);
      chs_lit(LinkedProg@linkedprogram__name, name);
      move(LinkedProg@linkedprogram__program, poFile);
   
      if (insert(Links, LinkedProg) is DuplicateKey) {
	fe_error(Stop_Now, errorcode__general_error,
		 "Linked process module '%s' has same id as one with a different name",
		 name);
	discard(LinkedProg);
      }
    }
}


objectp
p_link_process(name)
char *name;
{
    lobject(Modulename);
    lobject(LinkEntry);
    objectp Processid;

    chs_lit(Modulename, name);
    Processid = new_object();

    if (h_lookup(LinkEntry, LinknameSet, Modulename, nil) is NotFound) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Process module '%s' did not appear in the 'linking' list",
		 name);
	unique(Processid);	/* cons up a fake one */
    }
    else if (h_lookup_secondary(LinkEntry, Links, Modulename, nil)
	     is NotFound)
      unique(Processid);	/* on linking list but unable to load */
    else
      copy(Processid, LinkEntry@Id);

    return(Processid);
}
