-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixdefs.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixdefs.p	1.1 7/28/89

-- Program to pre-process a definitions module
-- getting rid of all the uses of FULL and expanding them to INIT
-- filling in minimum formal typestate for callmessages

abbrev_expand: using (inferredtype, interpform, objectIO, 
    checkdefs_internal, fixmin, fixdefs, errors, positions)
  process ( initport: FixdefsInport )

  declare
    FP: FixdefsCall; -- formal parameters
    fixfull: FixFullOutport; -- program to replace full by init
    insert_minimum: FixMinOutport; -- program to insert minimum TS
    modules: module_table;  -- modules to use for resolution
    
    newdefinition: type_definition; -- definition being recreated
    newdefinitions: type_definitions; -- module being recreated
    newcasemapping: partitionset; 
    newpartition: partition_info;
    cmtype: typename;
    newexceptionspecifications: exception_specifications;
    newexceptionspecification: exception;
  
    errorTemplate: error;
    errtem: error;
    errObj: errorObject;
  begin 
    receive FP from initport;

    -- Load the code for subprograms
    fixfull <- PROCEDURE OF fp.std.pathload("fixfull");
    insert_minimum <- PROCEDURE OF fp.std.pathload ("fixmin");
    
    -- initialize errors
    new FP.errors;
    
    new errorTemplate;
    errorTemplate.code := 'definition error';
    unite errorTemplate.position.apos from 
      (evaluate pos: aposition from
            new pos; 
            pos.clause := unique;
            pos.statement := unique;
          end);
    new errorTemplate.objects;
    unite errobj.moduleid from copy of fp.ToBeFixed.id;
    insert errobj into errorTemplate.objects;
    
    -- build modules library consisting of the checked library plus this
    -- module
    new modules;
    for defmod in fp.definitions where ('true')
      inspect
        insert copy of defmod into modules;
      end for;
    insert copy of fp.ToBeFixed into modules;
    
    -- Pass I: fixing full/init(*) and defaulting minimum typestate
    -- 7. fix the full in all formal TS's in the module to be fixed
    -- 8. for callmessages,
    --    if the user didn't supply a minimum
    --    (which we infer by empty formal-typestate), then
    --    generate one in the following way:
    --    init(*)
    --    For each constant parameter P, include init(P) if it's in exit TS.
    --      If P is a record/cm, recursively include components of P if in 
    --    exit TS.
    --    Also, we make sure that the normal and exception exit typestates 
    --    all contain init(*).  (fixfull does this for non-empty typestates,
    --    we do it for empty ones)
    -- 8b. for inports,
    --    if the message_type message_type is a callmessage, we also make
    --    sure init(*) is present.  Note that this effectively prevents us
    --    from 'send'ing uninit callmessages using the concrete syntax, though
    --    it is legal in the absprog.
    
    -- This is done in the do_shorten module:  
    -- Pass II: suppressing attributes already implied by init(cm)
    -- 9. for each formal TS in the module to be fixed, except CM minimums
    --   identify attributes of the form init(x), where x is a callmessage,
    --    (a) expand (recursively) all implied attributes
    --    (b) delete all implied attributes
    -- End pass II
      
    new newdefinitions;
    while (size of FP.ToBeFixed.type_definitions > 0)
      repeat
        remove newdefinition from n in FP.ToBeFixed.type_definitions 
           where('true');
        select (case of newdefinition.specification)
          where('varianttype')
            reveal newdefinition.specification.variant_info;
            new newcasemapping;
            while (size of newdefinition.specification.variant_info.case_mapping > 0)
              repeat
                remove newpartition from p in 
                   newdefinition.specification.variant_info.case_mapping 
                   where('true');
              block begin
                inspect componentdeclaration in 
                       newdefinition.component_declarations 
                       where(componentdeclaration.id = newpartition.component_id)
                  begin
                    errtem := errortemplate;
                    unite errobj.typeid from copy of newdefinition.id;
                    insert errobj into errtem.objects;
                    call fixfull(Modules, 
                        newpartition.case_typestate,
                        componentdeclaration.type, 
                        errtem,
                        FP.errors );
                  end inspect;
              on (NotFound)
                -- do nothing; checkdefs will catch this error
              end block;
                insert newpartition into newcasemapping;
              end while;
            newdefinition.specification.variant_info.case_mapping <- newcasemapping;
          where('inporttype')
            reveal newdefinition.specification.inport_info;
            -- 8b.
            if (size of newdefinition.specification.inport_info.message_typestate = 0) 
              then
                block 
                  begin
                    inspect defmod in modules[newdefinition.specification.inport_info.message_type.moduleid]
                      begin
                        inspect tdef in defmod.type_definitions[newdefinition.specification.inport_info.message_type.typeid]
                          begin
                            if case of tdef.specification = 'callmessagetype'
                              then
                                insert 
                                   (evaluate InitStar4: Formal_Attribute FROM
                                        NEW InitStar4;
                                        UNITE InitStar4.Attribute_Name.Init FROM 
                                          (evaluate Nothing: Empty FROM 
                                              END);
                                        NEW InitStar4.Parameters;
                                        INSERT 
                                           (EVALUATE Star: Component_List FROM
                                                NEW Star;
                                              END)
                                           INTO InitStar4.Parameters;
                                      END)
                                   into newdefinition.specification.inport_info.message_typestate;
                              end if;
                          end inspect;
                      end inspect;
                  on (NotFound)
                    -- bad definition; checkdefs will catch
                  end block;
              else
                errtem := errortemplate;
                unite errobj.typeid from copy of newdefinition.id;
                insert errobj into errtem.objects;
                call fixfull(Modules,
                    newdefinition.specification.inport_info.message_typestate,
                    newdefinition.specification.inport_info.message_type,
                    errtem,
                    FP.errors );
              end if;
          where('tabletype')
            reveal newdefinition.specification.table_info;
            errtem := errortemplate;
            unite errobj.typeid from copy of newdefinition.id;
            insert errobj into errtem.objects;
            call fixfull(Modules,
                newdefinition.specification.table_info.element_typestate,
                newdefinition.specification.table_info.element_type,
                errtem,
                FP.errors );
          where('callmessagetype')
            reveal newdefinition.specification.callmessage_info;
            new cmtype;
            cmtype.moduleid := FP.ToBeFixed.id;
            cmtype.typeid := newdefinition.id;
            
            errtem := errortemplate;
            unite errobj.typeid from copy of newdefinition.id;
            insert errobj into errtem.objects;
            call fixfull(Modules,
                newdefinition.specification.callmessage_info.normal,
                cmtype,
                errtem,
                FP.errors );
            new newexceptionspecifications;
            while (size of newdefinition.specification.callmessage_info.exception_specifications > 0)
              repeat
                remove newexceptionspecification from e in
                   newdefinition.specification.callmessage_info.exception_specifications 
                   where('true');
                errtem := errortemplate;
                unite errobj.typeid from copy of newdefinition.id;
                insert errobj into errtem.objects;
                call fixfull(Modules,
                    newexceptionspecification.post_typestate,
                    cmtype,
                    errtem,
                    FP.errors );
                insert newexceptionspecification into 
                   newexceptionspecifications;
              end while;
            newdefinition.specification.callmessage_info.exception_specifications <- newexceptionspecifications;
            
            -- 8. 
            block
              declare
                DiscardedException: Exception;
              begin
                remove DiscardedException from exc in 
                   newdefinition.specification.callmessage_info.exception_specifications 
                   where(exc.exceptionid = newdefinition.specification.callmessage_info.minimum);
                IF SIZE OF DiscardedException.Post_Typestate = 0
                  THEN
                    new DiscardedException.Post_Typestate;
                    insert 
                       (evaluate InitStar: Formal_Attribute FROM
                            NEW InitStar;
                            UNITE InitStar.Attribute_Name.Init FROM 
                              (evaluate Nothing: Empty FROM 
                                  END);
                            NEW InitStar.Parameters;
                            INSERT 
                               (EVALUATE Star: Component_List FROM
                                    NEW Star;
                                  END)
                               INTO InitStar.Parameters;
                          END)
                       INTO DiscardedException.Post_Typestate;
                    for constant in newdefinition.specification.callmessage_info.constants where('true')
                      inspect
                        call insert_minimum(constant,
                            evaluate Null: Component_List from 
                                new Null;
                              END, 
                            newdefinition.component_declarations, 
                            Modules, 
                            newdefinition.specification.callmessage_info.normal,
                            DiscardedException.Post_Typestate);
                      end for;
                  END IF; 
                insert DiscardedException into 
                   newdefinition.specification.callmessage_info.exception_specifications;
              on (NotFound)
                -- minimum exceptionid not found; checkdefs will catch this
              end block;
          
            -- now make sure normal and exception 
            -- typestates are not empty (if they are, add init(*))
            
            if size of newdefinition.specification.callmessage_info.normal = 0
              then
                insert 
                   (evaluate InitStar2: Formal_Attribute FROM
                        NEW InitStar2;
                        UNITE InitStar2.Attribute_Name.Init FROM 
                          (evaluate Nothing: Empty FROM 
                              END);
                        NEW InitStar2.Parameters;
                        INSERT 
                           (EVALUATE Star: Component_List FROM
                                NEW Star;
                              END)
                           INTO InitStar2.Parameters;
                      END)
                   into newdefinition.specification.callmessage_info.normal;
              end if;
            
            new newexceptionspecifications;
            while (size of newdefinition.specification.callmessage_info.exception_specifications > 0)
              repeat
                remove newexceptionspecification from e in
                   newdefinition.specification.callmessage_info.exception_specifications 
                   where('true');
                if size of newexceptionspecification.post_typestate = 0
                  then
                    insert 
                       (evaluate InitStar3: Formal_Attribute FROM
                            NEW InitStar3;
                            UNITE InitStar3.Attribute_Name.Init FROM 
                              (evaluate Nothing: Empty FROM 
                                  END);
                            NEW InitStar3.Parameters;
                            INSERT 
                               (EVALUATE Star: Component_List FROM
                                    NEW Star;
                                  END)
                               INTO InitStar3.Parameters;
                          END)
                       into newexceptionspecification.post_typestate;
                  end if;
                insert newexceptionspecification into 
                   newexceptionspecifications;
              end while;
            newdefinition.specification.callmessage_info.exception_specifications <- newexceptionspecifications;
            
          otherwise
          end select;
        
        insert newdefinition into newdefinitions;
      end while;
      
    FP.ToBeFixed.type_definitions <- newdefinitions;
    
    return FP;

  end process
