-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkdefs.d
-- Author: David F. Bacon
-- SCCS Info: @(#)checkdefs.d	1.5 4/19/91

checkDefs: using (errors, stdenv) definitions
    
    -- Important Note:  checkdefs, checkFormal_typestate, and
    -- checkcomponent_list assume
    -- that defs is a library of modules all of which are checked.
    -- Making this assumption means that
    -- we don't have to worry about unresolvable references to other modules.
    
    checkDefs: callmessage (
        std: stdenv,
        module: definitions_module, -- the module to be checked
        defs: definitions_modules,  -- the module library to check against
        typenames: typename_rec,  -- typenames out of predefined
        errors: errors
      ) constant (module, defs, std, typenames)
    exit { full };
    
    checkDefsQ: inport of checkDefs { full(module), init(defs), full(std),
      full(typenames)};
    checkDefsFn: outport of checkDefsQ;

    typename_rec: record (
        defmod: predefined!typename,
        program: predefined!typename
      );
    
  end definitions

