-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)errno.d	1.2 3/13/90

errno: USING (predefined)

DEFINITIONS

errno: ORDERED ENUMERATION (
 'unused',
 'EPERM'				/* Not owner */,
 'ENOENT'				/* No such file or directory */,
 'ESRCH'				/* No such process */,
 'EINTR'			  	/* Interrupted system call */,
 'EIO'					/* I/O error */,
 'ENXIO'				/* No such device or address */,
 'E2BIG'				/* Arg list too long */,
 'ENOEXEC'				/* Exec format error */,
 'EBADF'				/* Bad file number */,
 'ECHILD'				/* No children */,
 'EAGAIN'				/* No more processes */,
 'ENOMEM'				/* Not enough core */,
 'EACCES'				/* Permission denied */,
 'EFAULT'				/* Bad address */,
 'ENOTBLK'				/* Block device required */,
 'EBUSY'				/* Mount device busy */,
 'EEXIST'				/* File exists */,
 'EXDEV'				/* Cross-device link */,
 'ENODEV'				/* No such device */,
 'ENOTDIR'				/* Not a directory*/,
 'EISDIR'				/* Is a directory */,
 'EINVAL'				/* Invalid argument */,
 'ENFILE'				/* File table overflow */,
 'EMFILE'				/* Too many open files */,
 'ENOTTY'				/* Not a typewriter */,
 'ETXTBSY'				/* Text file busy */,
 'EFBIG'				/* File too large */,
 'ENOSPC'				/* No space left on device */,
 'ESPIPE'				/* Illegal seek */,
 'EROFS'				/* Read-only file system */,
 'EMLINK'				/* Too many links */,
 'EPIPE'				/* Broken pipe */,

/* math software */
 'EDOM'				/* Argument too large */,
 'ERANGE'			/* Result too large */,

/* non-blocking and interrupt i/o */
 'EWOULDBLOCK'			/* Operation would block */,
 'EINPROGRESS'			/* Operation now in progress */,
 'EALREADY'			/* Operation already in progress */,
/* ipc/network software */

	/* argument errors */
 'ENOTSOCK'			/* Socket operation on non-socket */,
 'EDESTADDRREQ'			/* Destination address required */,
 'EMSGSIZE'			/* Message too long */,
 'EPROTOTYPE'			/* Protocol wrong type for socket */,
 'ENOPROTOOPT'			/* Protocol not available */,
 'EPROTONOSUPPORT'		/* Protocol not supported */,
 'ESOCKTNOSUPPORT'		/* Socket type not supported */,
 'EOPNOTSUPP'			/* Operation not supported on socket */,
 'EPFNOSUPPORT'			/* Protocol family not supported */,
 'EAFNOSUPPORT'			/* Address family not supported by protocol family */,
 'EADDRINUSE'			/* Address already in use */,
 'EADDRNOTAVAIL'		/* Can't assign requested address */,

	/* operational errors */
 'ENETDOWN'			/* Network is down */,
 'ENETUNREACH'			/* Network is unreachable */,
 'ENETRESET'			/* Network dropped connection on reset */,
 'ECONNABORTED'			/* Software caused connection abort */,
 'ECONNRESET'			/* Connection reset by peer */,
 'ENOBUFS'				/* No buffer space available */,
 'EISCONN'				/* Socket is already connected */,
 'ENOTCONN'			/* Socket is not connected */,
 'ESHUTDOWN'			/* Can't send after socket shutdown */,
 'ETOOMANYREFS'			/* Too many references: can't splice */,
 'ETIMEDOUT'			/* Connection timed out */,
 'ECONNREFUSED'			/* Connection refused */,

	/* */
 'ELOOP'				/* Too many levels of symbolic links */,
 'ENAMETOOLONG'			/* File name too long */,

/* should be rearranged */
 'EHOSTDOWN'			/* Host is down */,
 'EHOSTUNREACH'			/* No route to host */,
 'ENOTEMPTY'			/* Directory not empty */,

/* quotas & mush */
 'EPROCLIM'			/* Too many processes */,
 'EUSERS'				/* Too many users */,
 'EDQUOT'				/* Disc quota exceeded */,

/* Network File System */
 'ESTALE'				/* Stale NFS file handle */,
 'EREMOTE'				/* Too many levels of remote in path */,

/* streams */
 'ENOSTR'				/* Device is not a stream */,
 'ETIME'				/* Timer expired */,
 'ENOSR'				/* Out of streams resources */,
 'ENOMSG'				/* No message of desired type */,
 'EBADMSG'				/* Trying to read unreadable message */,

/* SystemV IPC */
 'EIDRM'				/* Identifier removed */,

/* SystemV Record Locking */
 'EDEADLK'				/* Deadlock condition. */,
 'ENOLCK'				/* No record locks available. */
);

END DEFINITIONS
