-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)libinit.d	1.4 4/19/91

-- definitions for interfaces to initialize library output functions of stdenv
-- (libWriteObj and libStore).  both take an output capability (write or store)
-- and getCwd capability from which they find the directory in which to write.
-- they return a capability to their respective function (write or store).

libinit: using (predefined, objectio, load, cwd)
definitions

  initLibWriteObject: callmessage (
    write: writeObject_Func,
    getCwd: getCwdFn,
    libWrite: writeObject_Func
  ) constant (write, getCwd)
    exit { full };

  initLibWriteObjectQ: inport of initLibWriteObject 
	{ init(write), init(getCwd) };
  initLibWriteObjectFn: outport of initLibWriteObjectQ;


  initLibStore: callmessage (
    store: storeFunc,
    getCwd: getCwdFn,
    libStore: storeFunc
  ) constant (store, getCwd)
    exit { full };

  initLibStoreQ: inport of initLibStore { init(store), init(getCwd) };
  initLibStoreFn: outport of initLibStoreQ;

end definitions

