-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: libstore.p
-- Author: David F. Bacon
-- SCCS Info: @(#)libstore.p	1.5 3/13/90

-- Write a compiled program out to the "library" -- for now, this is just a
-- directory, so we just write it to getcwd() | "/" | modulename | ".po".

libstore: using (predefined, common, libinit, load, cwd)
process (initQ: initLibStoreQ)

declare
  initArgs: initLibStore;
  store: storeFunc;
  directory: charstring;
  filename: charstring;
  q: StoreQ;
  args: StoreIntf;
  getCwd: getCwdFn;

begin
  receive initArgs from initQ;
  store := initArgs.store;
  getCwd := initArgs.getCwd;
  new q;
  connect initArgs.libStore to q;
  return initArgs;

  while boolean#'true' repeat
    block begin
      receive args from q;
      filename <- charstring#(charstring#(charstring#(charstring#(
	  getCwd()) | charstring#"/") | args.modulename) | charstring#".po");
      call store(filename, args.program);
      return args;

    on (StoreIntf.cantStoreProgram)
      return args exception cantStoreProgram;
    end block;
  end while;
end process


