-- (C) Copyright International Business Machines Corporation 14 December
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)load_program.p	1.3 1/9/92

load_program: using (common, load, loadprogram, objectio, predefined) 
  process (initport: loadprogram_init_q)

declare

  init: loadprogram!loadprogram_init_intf;
  read: readobject_func;
  Q: load_q;
  request: load_intf;
  polyprog: polymorph;

begin

  receive init from initport;		-- initialization
  read := init.readobj;
  new Q;
  connect init.load to Q;
  return init;
  discard initport;

  while boolean#'true' repeat		-- service loop

    block begin

      receive request from Q;
      polyprog <- polymorph#(read(request.modulename));
      unwrap request.program from polyprog { init(*),
          init(definitions_modules), init(main_program), init(programs),
        checked(*)};
      return request;

    on (readobject_intf.Discarded, readobject_intf.file_not_found)
      return request exception file_not_found;
    on (readobject_intf.file_not_readable, PolymorphMismatch)
      return request exception CantLoadProgram;
    end block;

  end while;

end process
