-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)loadprog.p	1.8 1/9/92

loadProg: using (predefined, loadProg, filedef, parse, objectio, common)
process (callQ: loadProgQ)

declare
  call: loadProgIntf;
  filename: charstring; -- file name of program to load
  arbobj: polymorph; -- the program/definition loaded (as a polymorph)
  filedprog: filed_process; -- the program loaded (as a filed_process)
  filedef: filed_definition; -- the definition being loaded
  imports: module_printmap; -- the definitions needed by the module being loaded
  imported: module_printmap; -- the definitions we have already loaded
  neededModule: module_printrec; -- the description of a module we need to import
begin block begin
  -- compute the filename of the program to load
  block begin
    receive call from callQ;
  on (Disconnected)
    exit PrematureTermination;
  end block;
  filename <- charstring#(call.moduleName | charstring#".ao");

  -- get the filed_process version of that program from the disk
  BLOCK
    BEGIN
      arbobj <- polymorph#(call.readobj(filename));
      unwrap filedprog from arbobj { 
	init, init(main_program), init(programs), init(procmaps),
	init(direct_imports), init(links), init(posmaps) };
    ON (ReadObject_Intf.File_Not_Found)
      RETURN call EXCEPTION ProgramNotFound;
      EXIT PrematureTermination;
    END BLOCK;

  -- initialize the output to the executable program just read
  -- plus the executable mappings just read
  -- plus an empty set of definitions and definitions-mappings
  new call.program;
  call.program.main_program <- filedprog.main_program;
  call.program.programs <- filedprog.programs;
  call.procmaps <- filedprog.procmaps;		-- suffices until constraints
  call.links <- filedprog.links;
  call.posmap <- filedprog.posmaps;
  
      new call.program.definitions_modules;
  new call.defmaps;

  -- initially the definitions needed come from the process's imports list
  -- and the set of definitions already loaded is empty  
--  imports <- filedprog.direct_imports;
  new imports;
  for i in filedprog.direct_imports[] inspect
      insert module_printrec#(copy of i) into imports;
    end for;
-- replace above lines with assignment statement when remove bug is fixed!
  
  new imported;

  -- if there are imports required, bring them in
  while boolean#(integer#(size of imports) <> integer#0) repeat
    block begin
      -- get the name of a module which needs to be imported
      remove NeededModule from imports[];

      -- read the definition from disk
      filename <- charstring#(NeededModule.name | charstring#".do");
      arbobj <- polymorph#(call.readobj(filename));
      unwrap filedef from arbobj {
	init, init(definitions_module), init(definitions_module.id),
	init(definitions_module.type_definitions),
	init(definitions_module.attr_definitions),
	checkeddefinitions(definitions_module),
	init(defmap), init(defmap.id), init(defmap.name),
	init(defmap.types), init(defmap.attributes),
	init(defmap.components), init(defmap.exceptions),
	init(procmaps), init(direct_imports) };
      -- verify that the moduleid on disk matches the moduleid expected
      if boolean #(filedef.definitions_module.id <> NeededModule.id) 
        then
          call.BadModule := NeededModule.Name;
          discard call.defmaps;
          discard call.procmaps;
          discard call.program;
          RETURN call EXCEPTION DefinitionInconsistent;
          EXIT PrematureTermination;
        end if;

      -- append the definitions module and definitions printmap
      insert filedef.definitions_module into call.program.definitions_modules;
      insert filedef.defmap into call.defmaps;

      -- put the module name into the set of modules imported
      insert NeededModule into imported;	-- remember that we imported this one
      
      -- for each module imported by the definition:
      -- if it hasn't been imported yet, add it to the list of needed imports
      -- if it has been imported already, verify that the expected moduleid matches the loaded moduleid
      for map in filedef.direct_imports[] inspect 
	block begin
	  inspect ImportedModule IN Imported WHERE(boolean # (ImportedModule.Name = Map.Name))
	    BEGIN
	      IF boolean #(ImportedModule.Id <> Map.Id)
	        THEN
	          call.badmodule := Map.Name;
		  discard call.defmaps;
		  discard call.procmaps;
		  discard call.program;
		  RETURN call EXCEPTION DefinitionInconsistent;
		  EXIT PrematureTermination;
	        END IF;
	    END INSPECT;
	on (NotFound)
	  BLOCK
	    BEGIN
	      insert module_printrec#(copy of map) into imports;
	    ON (DuplicateKey)
	    END BLOCK;
	end block;
      end for;

      discard filedef.direct_imports;

    on (readobject_intf.file_not_found)  
      Call.BadModule := NeededModule.Name;
      discard call.defmaps;
      discard call.procmaps;
      discard call.program;
      RETURN call EXCEPTION DefinitionNotFound;
      EXIT PrematureTermination;
    end block;
  end while;
RETURN call;
  
ON EXIT (PrematureTermination)
ON (OTHERS)
  print charstring # "Something went wrong in loadprog";

end block;
end process
