-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: sortprocerrors.p
-- Author: Andy Lowry
-- SCCS Info: @(#)sortprocerrors.p	1.2 1/27/92

-- Sort procError records according to their source code positions; in
-- the process, change any absprog position markers to source code
-- position markers.

sortProcErrors: using (sortErrors, errors, positions)

process (Q: sortProcErrorsQ)

declare
  args: sortProcErrors;
  test: compareCPositionsFn;
  ncpos: integer;
  i: integer;
  j: integer;
  err: procError;
begin
  -- get a comparator for cpositions
  test <- procedure of (process (Q: compareCPositionsQ)
    declare
      args: compareCPositions;
      file1: charstring;
      file2: charstring;
      c1: char;
      c2: char;
    begin
      receive args from Q;
      file1 := args.pos1.file;
      file2 := args.pos2.file;

      block begin
	if file1 <> file2 then
	  while 'true' repeat
	    block begin
	      remove c1 from file1[];
	    on (notFound)
	      exit noswitch;		-- file1 is prefix of file2
	    end block;
	    block begin
	      remove c2 from file2[];
	    on (notFound)
	      exit switch;		-- file2 is prefix of file1
	    end block;
	    if c1 < c2 then
	      exit noswitch;
	    else
	      if c2 < c1 then
		exit switch;
	      end if;
	    end if;
	  end while;
	  exit cantHappen;
	else
	  if args.pos1.line < args.pos2.line then
	    exit noswitch;
	  else
	    if args.pos2.line < args.pos1.line then
	      exit switch;
	    else
	      if args.pos2.column < args.pos1.column then
		exit switch;
	      else
		exit noswitch;
	      end if;
	    end if;
	  end if;
	end if;
      on exit(switch)
	args.switch <- 'true';
      on exit(noswitch)
	args.switch <- 'false';
      end block;
      return args;
    on exit(cantHappen)
    end process);

  receive args from Q;

  -- convert as many apositions as we can into cpositions
  for e in args.errors[] inspect
    if case of e.error.position = 'absprog' then
      block declare
	eid: executable_id;
      begin
	unite eid.pid from copy of e.procId;
	reveal e.error.position.apos;
	inspect map in args.posmaps[eid] begin
	  inspect entry in map.mapping[e.error.position.apos] begin
	    remove err from args.errors[position of e];
	    unite err.error.position.cpos from copy of entry.cposition;
	    insert err into args.errors at position of e;
	  end inspect;
	end inspect;
      on (notFound)		-- leave it as an aposition
      end block;
    end if;
  end for;
  
  -- move aposition error records to the end, and count the cpos entries
  block begin
    i <- position of e in args.errors where
	(case of e.error.position = 'absprog');
    ncpos <- size of args.errors;
    while i < ncpos - 1 repeat
      ncpos <- ncpos - 1;
      remove err from args.errors[ncpos];
      insert err into args.errors at i;
      if i + 1 < ncpos then
	remove err from args.errors[i + 1];
	insert err into args.errors;
      end if;
      i <- position of e in args.errors where
	  (case of e.error.position = 'absprog');
    end while;
  on (notFound)
    ncpos <- size of args.errors;
  end block;
  
  -- now just do a simple bubble sort
  i <- 0;
  while i < ncpos - 1 repeat
    j <- ncpos - 1;
    while j > i repeat
      inspect err1 in args.errors[j - 1] begin
	reveal err1.error.position.cpos;
	inspect err2 in args.errors[j] begin
	  reveal err2.error.position.cpos;
	  if test(err1.error.position.cpos,err2.error.position.cpos) then
	    remove err from args.errors[j];
	    insert err into args.errors at j - 1;
	  end if;
	end inspect;
      end inspect;
      j <- j - 1;
    end while;
    i <- i + 1;
  end while;

  return args;
end process
    
