-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: absformat.d
-- Author: Andy Lowry
-- SCCS Info: @(#)absformat.d	1.8 2/5/92

AbsFormat: using (predefined, inferredtype, errors, posmap) definitions

  -- procedure to print an object name
  FormatObjectCall: CALLMESSAGE (
    Formatters: Formatters,
    Declarations: Scopes,
    InferredDeclarations: InferredDefinitions,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    ExecutableMap: Executable_Printmap,
    Object: ObjectName,
    FormatValue: Charstring
  )
  CONSTANT (
    Formatters, Declarations, InferredDeclarations, Definitions,
    DefinitionsMap, ExecutableMap, Object)
  EXIT{full};
  FormatObjectInport: INPORT OF FormatObjectCall {
    full(Formatters), full(Declarations), full(InferredDeclarations),
    full(Definitions), full(DefinitionsMap), full(ExecutableMap), 
    full(Object) } ;
  FormatObjectOutport: OUTPORT OF FormatObjectInport;

  -- procedure to format a root name
  FormatRootCall: CALLMESSAGE (
    Formatters: Formatters,
    Declarations: Scopes,
    InferredDeclarations: InferredDefinitions,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    ExecutableMap: Executable_Printmap,
    Root: RootName,
    Type: TypeName, -- typename returned
    FormatValue: Charstring
  )
  CONSTANT (
    Formatters, Declarations, InferredDeclarations, Definitions,
    DefinitionsMap, ExecutableMap, Root)
  EXIT{full};
  FormatRootInport: INPORT OF FormatRootCall {
    full(Formatters), full(Declarations), full(InferredDeclarations), 
    full(Definitions), full(DefinitionsMap), full(ExecutableMap), 
    full(Root) };
  FormatRootOutport: OUTPORT OF FormatRootInport;

  -- procedure to format a component list
  FormatComponentsCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    Components: Component_List,
    Type: TypeName, -- typename of root
    FormatValue: Charstring
  )
  CONSTANT(Formatters, Definitions,  DefinitionsMap, Components, Type)
  EXIT{full};
  FormatComponentsInport: INPORT OF FormatComponentsCall {
    full(Formatters),  full(Definitions), full(DefinitionsMap),
    full(Components), full(Type) };
  FormatComponentsOutport: OUTPORT OF FormatComponentsInport;

  -- procedure to format a typename
  FormatTypeCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    Type: TypeName,
    FormatValue: Charstring
  )
  CONSTANT(Formatters,  Definitions, DefinitionsMap, Type)
  EXIT{full};
  FormatTypeInport: INPORT OF FormatTypeCall {
    full(Formatters), full(Definitions), full(DefinitionsMap), 
    full(Type)} ;
  FormatTypeOutport: OUTPORT OF FormatTypeInport;

  -- procedure to format a formal attributename
  FormatFormalAttributeCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    FormalAttribute: Formal_Attribute,
    Type: TypeName, -- typename of implied root
    FormatValue: Charstring
  )
  CONSTANT (Formatters,  Definitions, DefinitionsMap, FormalAttribute, Type)
  EXIT{full};
  FormatFormalAttributeInport: INPORT OF FormatFormalAttributeCall {
    full(Formatters),  full(Definitions), full(DefinitionsMap),
    full(FormalAttribute), full(Type)} ;
  FormatFormalAttributeOutport: OUTPORT OF FormatFormalAttributeInport;

  -- procedure to format a formal typestate
  FormatFormalTypestateCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    FormalTypestate: Formal_Typestate,
    Type: TypeName, -- typename of implied root
    FormatValue: Charstring
  )
  CONSTANT (Formatters,  Definitions, DefinitionsMap, FormalTypestate, Type)
  EXIT{full};
  FormatFormalTypestateInport: INPORT OF FormatFormalTypestateCall {
    full(Formatters), full(Definitions), full(DefinitionsMap),
    full(FormalTypestate), full(Type)} ;
  FormatFormalTypestateOutport: OUTPORT OF FormatFormalTypestateInport;

  -- procedure to format an attribute name
  FormatAttributeNameCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    AttributeName: Attribute_Name,
    FormatValue: Charstring
  )
  CONSTANT (Formatters,  Definitions, DefinitionsMap, AttributeName)
  EXIT{full};
  FormatAttributeNameInport: INPORT OF FormatAttributeNameCall {
    full(Formatters), full(Definitions), full(DefinitionsMap),
    full(AttributeName)} ;
  FormatAttributeNameOutport: OUTPORT OF FormatAttributeNameInport;

  -- procedure to format an attribute
  FormatAttributeCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    Declarations: Scopes,
    InferredDeclarations: InferredDefinitions,
    DefinitionsMap: Definitions_PrintMappings,
    ExecutableMap: Executable_Printmap,
    Attribute: Attribute,
    FormatValue: Charstring
  )
  CONSTANT (
    Formatters,  Definitions, Declarations, InferredDeclarations,
    DefinitionsMap, ExecutableMap, Attribute)
  EXIT{full};
  FormatAttributeInport: INPORT OF FormatAttributeCall {
    full(Formatters), full(Declarations), full(InferredDeclarations),
    full(Definitions), full(DefinitionsMap), full(ExecutableMap),
    full(Attribute)} ;
  FormatAttributeOutport: OUTPORT OF FormatAttributeInport;

  -- procedure to format a typestate
  FormatTypestateCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    Declarations: Scopes,
    InferredDeclarations: InferredDefinitions,
    DefinitionsMap: Definitions_PrintMappings,
    ExecutableMap: Executable_Printmap,
    Typestate: Typestate,
    FormatValue: Charstring
  )
  CONSTANT(
    Formatters,  Definitions, Declarations, InferredDeclarations, 
    DefinitionsMap, ExecutableMap, Typestate)
  EXIT{full};
  FormatTypestateInport: INPORT OF FormatTypestateCall {
    full(Formatters), full(Definitions), full(DefinitionsMap), 
    full(Declarations), full(InferredDeclarations), full(ExecutableMap),
    full(Typestate)} ;
  FormatTypestateOutport: OUTPORT OF FormatTypestateInport;

  -- procedure to format an opcode
  FormatOpcodeCall: CALLMESSAGE (
    Formatters: Formatters,
    Operator: Operator,
    FormatValue: Charstring
  )
  CONSTANT (Formatters, Operator)
  EXIT{full};
  FormatOpcodeInport: INPORT OF FormatOpcodeCall {
    full(Formatters), full(Operator)};
  FormatOpcodeOutport: OUTPORT OF FormatOpcodeInport;

  -- procedure to format a statement
  FormatStatementCall: CALLMESSAGE (
    Formatters: Formatters,
    Declarations: Scopes,
    InferredDeclarations: InferredDefinitions,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_PrintMappings,
    ExecutableMap: Executable_Printmap,
    Statement: Statement,
    FormatValue: Charstring
  ) 
  CONSTANT (
    Formatters, Declarations, InferredDeclarations, Definitions,
    DefinitionsMap, ExecutableMap, Statement) 
  EXIT{full};
  FormatStatementInport: INPORT OF FormatStatementCall {
    full(Formatters), full(Declarations), full(InferredDeclarations),
    full(Definitions), full(DefinitionsMap), full(ExecutableMap),
    full(Statement)};
  FormatStatementOutport: OUTPORT OF FormatStatementInport;

  -- procedure to format a handler name
  FormatHandlerNameCall: CALLMESSAGE (
    Formatters: Formatters,
    Definitions: Definitions_Modules,
    DefinitionsMap: Definitions_Printmappings,
    ExecutableMap: Executable_Printmap,
    HandlerName: handlername,
    FormatValue: Charstring
  )
  CONSTANT (
    Formatters, Definitions, DefinitionsMap, ExecutableMap, Handlername)
  EXIT {full};
  FormatHandlerNameInport: INPORT OF FormatHandlerNameCall {    
    full(Formatters), full(Definitions), full(DefinitionsMap),
    full(ExecutableMap), full(HandlerName)};
  FormatHandlerNameOutport: OUTPORT OF FormatHandlerNameInport;
    
  -- Service Routines
  Formatters: RECORD (
    FormatObject: FormatObjectOutport,
    FormatRoot: FormatRootOutport,
    FormatComponents: FormatComponentsOutport,
    FormatType: FormatTypeOutport,
    FormatAttributeName: FormatAttributeNameOutport,
    FormatFormalAttribute: FormatFormalAttributeOutport,
    FormatFormalTypestate: FormatFormalTypestateOutport,
    FormatAttribute: FormatAttributeOutport,
    FormatTypestate: FormatTypestateOutport,
    FormatOpcode: FormatOpcodeOutport,
    FormatStatement: FormatStatementOutport,
    FormatHandlerName: FormatHandlerNameOutport
  );
      
  GetFormattersCall: CALLMESSAGE (
    Formatters: Formatters
  )
  EXIT {full};
  GetFormattersInport: INPORT OF GetFormattersCall {};
  GetFormattersOutport: OUTPORT OF GetFormattersInport;

end definitions
