-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)stdenv.d	1.4 3/13/90

stdenv: using (predefined, load, objectIO, terminalIO, cwd) definitions

-- note: on the next iteration of changes the absolute-filename versions of
--  object and program i/o should probably be moved to a separate record which
--  is passed in on the main interface but not much further.  applications 
--  should actually use the path* and lib* functions, not load, readObj, and
--  writeObj.

  stdenv: record (
    load: load_func,		-- load compiled program from absolute filename
    pathLoad: load_func,	-- load compiled program path-relative filename

    readObj: readobject_func,	-- read an arbitrary Hermes object from an
				--  absolute filename
    pathReadObj: readobject_func, -- read an object from a "library" (currently
				  --  implemented as a directory path).
    writeObj: writeobject_func,	-- write an arbitrary Hermes object to an
				--  absolute filename.
    libWriteObj: writeobject_func, -- write an object to a "library" (currently
				   --  a directory).
    store: storeFunc,		-- store a program to an absolute filename.
    libStore: storeFunc,	-- store a program in a library (currently a
				--  directory).

    getCwd: getCwdFn,		-- get current working directory
    setCwd: setCwdFn,		-- set current working directory

    terminal: terminalFunctions	-- functions for doing I/O to the "terminal"
  );

end definitions

