-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)typecheck.d	1.2 3/13/90

typecheck: using(predefined, checking_table, inferredtype, errors, stdenv)
definitions

  TypecheckCall: callmessage (
    program: proc,
    definitions: definitions_modules,
    checking_table: checking_table,
    stdenv: stdenv,
    errors: errors,
    inferred: InferredDefinitions
  ) constant (program, definitions, checking_table, stdenv)
    exit { full }
    exception typeerrors { full };	-- maybe inferred should be bottom?

  TypeCheckQueue: inport of typecheckCall { full(program), full(definitions),
			full(checking_table), full(stdenv) };
-- errors and inferred are bottom at call
  TypeCheckCapa: outport of typecheckQueue;

end definitions
