-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unixint.d	1.1 1/11/92

-- Internal definitions needed for the implementation of services
-- whose interfaces appear in unix.d

unixint: using (unix, cload) definitions
  
  -- assume we can store unix stream handles in integers
  rawStream: integer;

  -- version of fopen interface that returns a status indicator rather
  -- than raising an exception on failure, and returns a raw stream
  -- rather than the hermes-friendly stream record
  fopenx: callmessage (
    filename: charstring,	-- file to open
    type: openType,		-- how to open it
    stream: rawStream,		-- the open stream handle
    opened: boolean		-- did the open succeed?
  )
  constant (filename, type)
  exit {full};
  fopenxQ: inport of fopenx {init(filename), init(type)};
  fopenxFn: outport of fopenxQ;
  
  -- similar variant on the fdopen interface
  fdopenx: callmessage (
    filedes: integer,		-- file descriptor from which to
				-- create stream
    type: openType,		-- how to open the stream
    stream: rawStream,		-- the open stream handle
    opened: boolean		-- did the open succeed?
  )
  constant (filedes, type)
  exit {full};
  fdopenxQ: inport of fdopenx {init(filedes), init(type)};
  fdopenxFn: outport of fdopenxQ;
  
  -- and another, for popen
  popenx: callmessage (
    command: charstring,	-- command to run in child process
    type: popenType,		-- direction of pipe
    stream: rawStream,		-- the open stream handle
    opened: boolean		-- did the open succeed?
  )
  constant (command, type)
  exit {full};
  popenxQ: inport of popenx {init(command), init(type)};
  popenxFn: outport of popenxQ;
  
  -- and again for tmpfile
  tmpfilex: callmessage (
    stream: rawStream,		-- the opened stream handle
    opened: boolean		-- did the open succeed?
  )
  exit {full};
  tmpfilexQ: inport of tmpfilex {};
  tmpfilexFn: outport of tmpfilexQ;
  
  -- version of fseek that has a return status instead of an exception
  fseekx: callmessage (
    offset: integer,		-- desired position in stream
    seekType: seekType,		-- where offset is measured from
    result: integer		-- completion status
  )
  constant (offset, seekType)
  exit {full};
  fseekxQ: inport of fseekx {init(offset), init(seekType)};
  fseekxFn: outport of fseekxQ;
  
  -- ditto for fclose
  fclosex: callmessage (
    result: integer		-- completion status
  )
  exit {full};
  fclosexQ: inport of fclosex {};
  fclosexFn: outport of fclosexQ;
  
  -- and for freopen -- notice that the rawstream is unchanged, so the
  -- stream stashed in the process state of the various c-hermes
  -- processes corresponding to this stream will automatically refer
  -- to the reopened stream
  freopenx: callmessage (
    filename: charstring,	-- new file to be opened
    type: openType,		-- how to open it
    opened: boolean		-- did the open succeed?
  )
  constant (filename, type)
  exit {full};
  freopenxQ: inport of freopenx {init(filename), init(type)};
  freopenxFn: outport of freopenxQ;
  
  -- initialization interfaces for stream-oriented services; mostly
  -- these just provide a raw stream and get back a capability for an
  -- operation on that stream
  clearerrInit: callmessage (
    stream: rawStream,
    capa: clearerrFn
  )
  constant (stream)
  exit {full};
  clearerrInitQ: inport of clearerrInit {init(stream)};
  clearerrInitFn: outport of clearerrInitQ;
  
  ferrorInit: callmessage (
    stream: rawStream,
    capa: ferrorFn
  )
  constant (stream)
  exit {full};
  ferrorInitQ: inport of ferrorInit {init(stream)};
  ferrorInitFn: outport of ferrorInitQ;
  
  ferrnoInit: callmessage (
    stream: rawStream,
    capa: readErrnoFn
  )
  constant (stream)
  exit {full};
  ferrnoInitQ: inport of ferrnoInit {init(stream)};
  ferrnoInitFn: outport of ferrnoInitQ;
  
  feofInit: callmessage (
    stream: rawStream,
    capa: feofFn
  )
  constant (stream)
  exit {full};
  feofInitQ: inport of feofInit {init(stream)};
  feofInitFn: outport of feofInitQ;

  filenoInit: callmessage (
    stream: rawStream,
    capa: filenoFn
  )
  constant (stream)
  exit {full};
  filenoInitQ: inport of filenoInit {init(stream)};
  filenoInitFn: outport of filenoInitQ;
  
  fflushInit: callmessage (
    stream: rawStream,
    capa: fflushFn
  )
  constant (stream)
  exit {full};
  fflushInitQ: inport of fflushInit {init(stream)};
  fflushInitFn: outport of fflushInitQ;
  
  fseekInit: callmessage (
    stream: rawStream,
    capa: fseekxFn
  )
  constant (stream)
  exit {full};
  fseekInitQ: inport of fseekInit {init(stream)};
  fseekInitFn: outport of fseekInitQ;
  
  rewindInit: callmessage (
    stream: rawStream,
    capa: rewindFn
  )
  constant (stream)
  exit {full};
  rewindInitQ: inport of rewindInit {init(stream)};
  rewindInitFn: outport of rewindInitQ;
  
  ftellInit: callmessage (
    stream: rawStream,
    capa: ftellFn
  )
  constant (stream)
  exit {full};
  ftellInitQ: inport of ftellInit {init(stream)};
  ftellInitFn: outport of ftellInitQ;
  
  setlinebufInit: callmessage (
    stream: rawStream,
    capa: setlinebufFn
  )
  constant (stream)
  exit {full};
  setlinebufInitQ: inport of setlinebufInit {init(stream)};
  setlinebufInitFn: outport of setlinebufInitQ;
  
  fstatInit: callmessage (
    stream: rawStream,
    capa: fstatFn
  )
  constant (stream)
  exit {full};
  fstatInitQ: inport of fstatInit {init(stream)};
  fstatInitFn: outport of fstatInitQ;
  
  fcloseInit: callmessage (
    stream: rawStream,
    capa: fclosexFn
  )
  constant (stream)
  exit {full};
  fcloseInitQ: inport of fcloseInit {init(stream)};
  fcloseInitFn: outport of fcloseInitQ;
  
  pcloseInit: callmessage (
    stream: rawStream,
    capa: pcloseFn
  )
  constant (stream)
  exit {full};
  pcloseInitQ: inport of pcloseInit {init(stream)};
  pcloseInitFn: outport of pcloseInitQ;
  
  freopenInit: callmessage (
    stream: rawStream,
    capa: freopenxFn
  )
  constant (stream)
  exit {full};
  freopenInitQ: inport of freopenInit {init(stream)};
  freopenInitFn: outport of freopenInitQ;
  
  -- interfaces and intialialization interfaces for utility functions
  -- that actually perform input and output operations on streams
  readStream: callmessage (
    count: integer,		-- read at most this many characters
    stopOnNL: boolean,		-- or until newline if this flag is true
    data: charstring,		-- data is returned here
    termCode: readTermCode	-- what caused the read operation to stop
  )
  constant (count, stopOnNL)
  exit {full};
  readStreamQ: inport of readStream {init(count), init(stopOnNL)};
  readStreamFn: outport of readStreamQ;

  readTermCode: enumeration (	-- reasons for a read operation to stop
    'ERROR',			-- an error condition was encountered
    'COUNT',			-- the supplied character count was exhausted
    'NEWLINE'			-- the stopOnNL arg was true and a
				-- newline was encountered
  );

  readStreamInit: callmessage (
    stream: rawStream,
    capa: readStreamFn
  )
  constant (stream)
  exit {full};
  readStreamInitQ: inport of readStreamInit {init(stream)};
  readStreamInitFn: outport of readStreamInitQ;
  
  readWord: callmessage (
    value: integer,		-- value of word read from stream, as integer
    error: boolean		-- did an error occur on the read?
  )
  exit {full};
  readWordQ: inport of readWord {};
  readWordFn: outport of readWordQ;
  
  readWordInit: callmessage (
    stream: rawStream,
    capa: readWordFn
  )
  constant (stream)
  exit {full};
  readWordInitQ: inport of readWordInit {init(stream)};
  readWordInitFn: outport of readWordInitQ;
  
  writeStream: callmessage (
    data: charstring,		-- chars to be written
    start: integer ,		-- where to start writing from
    count: integer,		-- how many chars to write
    written: integer		-- how many chars actually written
  )
  constant (data, start, count)
  exit {full};
  writeStreamQ: inport of writeStream {init(data), init(start), init(count)};
  writeStreamFn: outport of writeStreamQ;
  
  writeStreamInit: callmessage (
    stream: rawStream,
    capa: writeStreamFn
  )
  constant (stream)
  exit {full};
  writeStreamInitQ: inport of writeStreamInit {init(stream)};
  writeStreamInitFn: outport of writeStreamInitQ;
  
  writeWord: callmessage (
    value: integer,		-- value of word to be written to stream
    error: boolean		-- did an error occur on the write?
  )
  constant (value)
  exit {full};
  writeWordQ: inport of writeWord {init(value)};
  writeWordFn: outport of writeWordQ;
  
  writeWordInit: callmessage (
    stream: rawStream,
    capa: writeWordFn
  )
  constant (stream)
  exit {full};
  writeWordInitQ: inport of writeWordInit {init(stream)};
  writeWordInitFn: outport of writeWordInitQ;

  -- initialization for stdio process
  stdioInit: callmessage (
    cload: CLoadFn,		-- so we can create C-Hermes support processes
    stdio: stdio
  )
  constant (cload)
  exit {full};
  stdioInitQ: inport of stdioInit {init(cload)};
  stdioInitFn: outport of stdioInitQ;
  
  -- interface for function that takes a raw stream and builds a
  -- complete stream record from it
  buildStream: callmessage (
    rawStream: rawStream,
    streamType: streamType,
    cload: CLoadFn,		-- so C-Hermes support can be loaded
    stream: stream
  )
  constant (rawStream, streamType, cload)
  exit {full};
  buildStreamQ: inport of buildStream 
      {init(rawStream),init(streamType),init(cload)};
  buildStreamFn: outport of buildStreamQ;

  streamType: enumeration ('normal', 'pipe');

  -- interface for function that returns raw stream handles for stdin,
  -- stdout, and stderr
  stdstreams: callmessage (
    stdin: rawstream,
    stdout: rawstream,
    stderr: rawstream
  )
  exit {full};
  stdstreamsQ: inport of stdstreams {};
  stdstreamsFn: outport of stdstreamsQ;

end definitions
