/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)print.c	1.13 1/23/91";
#endif

#include <stdio.h>

#include "ops.h"
#include "recursiv.h"
#include "accessors.h"

#define VARIANT_COMPONENT 0


/*ARGSUSED*/
void prt_noop(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    (void) fprintf(f, "**** No print routine for this data representation!!! ****\n");
}



/*ARGSUSED*/
void
prt_ord_scalar(f, indent, v)
FILE *f;
int indent;
valcell v;
{
    (void) fprintf(f, "%d\n", v.integer);
}




/*ARGSUSED*/
void
prt_boolean(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    if (val.boolean)
      (void) fprintf(f, "True\n");
    else
      (void) fprintf(f, "False\n");
}


/*ARGSUSED*/
void
prt_real(f, indent,v)
FILE *f;
int indent;
valcell v;
{
    struct xs {long x1,x2;};
    typedef struct xs rxs;

/*  (void) fprintf(f, "%e\n", *v.real); */
    (void) fprintf(f, "%24.16e = %08lx %08lx\n", *v.real,
		   ((rxs *)v.real)->x1, ((rxs *)v.real)->x2);
}



/*ARGSUSED*/
void
prt_nominal(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    (void) fprintf(f, " at 0x%x: [%u,%u]\n",
		   val.nominal, val.nominal->time, val.nominal->num);
}


/*ARGSUSED*/
void
prt_ord_enumeration(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    if (val.ord_enum > ' ' and val.ord_enum < '~')
      (void) fprintf(f, "%3d or '%c'\n", val.ord_enum, val.ord_enum);
    else
      (void) fprintf(f, "%d\n", val.ord_enum);
}



void
prt_record(f, indent, record)
FILE *f;
int indent;
valcell record;
{
    void re_print();
    void indent_for_print();

    counter size, i;
    

    size = record.record->info.record_size;
    
    indent++;
    (void) fprintf(f, " at 0x%x\n", record.record);

    for (i = 0; i < size; i++)
				/* print each of the components */
      re_print(f, indent, & record.record->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Record\n");
}



void
prt_program(f, indent, program)
FILE *f;
int indent;
valcell program;
{
    void re_print();
    void indent_for_print();

    counter i;
    

    indent++;
    (void) fprintf(f, " at 0x%x\n");

    for (i = 0; i < PROGRAM_SIZE; i++)
				/* print each of the components */
      re_print(f, indent, & program.program->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Program\n");
}



void
prt_callmessage(f, indent, cm)
FILE *f;
int indent;
valcell cm;
{
    void re_print();
    void indent_for_print();

    counter i;
    

    indent++;
    (void) fprintf(f, " at 0x%x\n", cm.callmessage);

    for (i = 0; i < cm.callmessage->info.callmessage->size; i++)
				/* print each of the components */
      re_print(f, indent, & cm.callmessage->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Callmessage\n");
}



void
prt_variant(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    void re_print();
    void indent_for_print();


    (void) fprintf(f," at 0x%x\n", val.variant);
    indent_for_print(f, indent+1);
    (void) fprintf(f, "case %d --\n", val.variant->info.variant_case);

    re_print(f, indent+1, & val.variant->data[VARIANT_COMPONENT]);


    indent_for_print(f, indent);
    (void) fprintf(f, "End of Variant\n");
}



void
prt_inport(f, indent, ip)
FILE *f;
int indent;
valcell ip;
{
    void indent_for_print();

    message *msgp;
    datarep *tsdr;
    local_inport *p;

    p = & ip.inport->info.inport;

    tsdr = p->tsdr;

    (void) fprintf(f, " at 0x%x", p);

    if (tsdr)
      (void) fprintf(f, "holds messages of type %s", tsdr->name);
    else
      (void) 
	fprintf(f, "holds messages of unknown type (queue should be empty)");

    (void) fprintf(f, ", connected to %d outports", ip.inport->refcount);

    if (ip.inport->disconnected)
      (void) fprintf(f, ", disconnected");

    if (p->waiting_owner)
      (void)
	fprintf(f, ", awaited by process at %u", p->waiting_owner);


    (void) fprintf(f, "\n");

    indent++;
    for (msgp = p->queue; msgp isnt nil; msgp = msgp->next) {
	indent_for_print(f, indent);
	if (tsdr)
	  (*tsdr->print)(f, indent, msgp->value);
	else
	  (void) fprintf(f, "Unable to print queued object\n");
    }
    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Inport\n");
}



void
prt_outport(f, indent, op)
FILE *f;
int indent;
valcell op;
{
  switch (op.outport->type) {
  case LocalInport:
    (void) fprintf(f, "Connected to local inport:\n");
    indent_for_print(f, ++indent);
    prt_inport(f, indent, op);
    indent_for_print(f, --indent);
    fprintf(f, "End of outport\n");
    break;
  case LocalProcport:
    (void) fprintf(f, "Connected to local procedure, primary PCB at %u, ",
		   op.outport->info.procedure);
    (void) fprintf(f, "%d references", op.outport->refcount);
    if (op.outport->disconnected)
      (void) fprintf(f, ", disconnected\n");
    else
      (void) fprintf(f, "\n");
    break;
  case RemotePort: {
    remote_address ra;
    int i;

    ra = op.outport->info.remote;
    (void) fprintf(f, "Connected to remote port at %u ", ra.addr);
    (void) fprintf(f, "in interpreter #%u on host ", ra.interp.number);
    for (i = 0; i < HOSTIDSIZE; i++)
      if (i == 0)
	fprintf(f,"%u", ra.interp.hostname[i]);
      else
	fprintf(f,".%u", ra.interp.hostname[i]);
    fprintf(f,"\n");
    break;
  }
  default:
    (void) fprintf(f, "Invalid port type\n");
  }
}    

void
print_keyset(f, keyset, keyname)
FILE *f;
dfd_table *keyset;
char *keyname;
{
    int key, field, offset, theoffset;
    valcell thekey, thefield;


    if (keyset->size is 0)
      return;

    (void) fprintf(f, ", %s ", keyname);

    for (key = 0; key < keyset->size; key++) {
	thekey = vec_elem(keyset, key);

	if (size_of(get_elem(thekey,0)) is 0)
	  (void) fprintf(f, "(*)");
	else {
	    (void) fprintf(f, "(");
	    for (field = 0; field < size_of(thekey); field++) {
		if (field > 0)
		  (void) fprintf(f, ",");

		thefield = get_elem(thekey, field);

		for (offset = 0; offset < size_of(thefield); offset++) {
		    if (offset > 0)
		      (void) fprintf(f, ".");

		    theoffset = get_elem(thefield, offset).integer;
		    (void) fprintf(f, "%d", theoffset);
		}
	    }
	    (void) fprintf(f, ") ");
	}
    }
}


void
prt_polymorph(f, indent, poly)
FILE *f;
int indent;
valcell poly;
{
    void indent_for_print();
    void re_print();
    void print_embedded_object();

    (void) fprintf(f, " at 0x%x\n", poly.polymorph);

    print_embedded_object(f, indent+1, "obj", & poly.polymorph->obj);
    print_embedded_object(f, indent+1, "typename", & poly.polymorph->typename);
    print_embedded_object(f, indent+1, "typestate", & poly.polymorph->typestate);

    indent_for_print(f, indent);
    (void) fprintf(f, "End of Polymorph\n");
}

void
print_embedded_object(f, indent, name, obj)
FILE *f;
int indent;
char *name;
object *obj;
{
    indent_for_print(f, indent);
    (void) fprintf(f, "%s: %s", name, obj->tsdr->name);
    Print(f, indent, obj);
}
