-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: linkserver.p
-- Author: Andy Lowry
-- SCCS Info: @(#)linkserver.p	1.3 3/11/91

-- This process services link requests from remote hermes
-- interpreters.  Each time a request comes in, a copy of the resource
-- manager is passed back.

linkServer: using (sysMain, distributed, sysRManager, CLoad)

process (Q: sysMainQ)
  
declare
  args: sysMain;
  sysRM: sysRManager;
  linkQ: genericQ;
  linkFn: genericFn;
  linkArgs: generic;
  CLoad: CLoadFn;
  setLink: setLinkingPortFn;
begin
  receive args from Q;
  unwrap CLoad from args.rm.get("system", "CLoader", "") {init};
  unwrap setLink from CLoad("set linking port") {init};

  -- create and install the link service ports
  new linkQ;
  connect linkFn to linkQ;
  call setLink(linkFn);
  
  -- copy the resource manager we'll be handing out
  sysRM := args.rm;
  
  -- return the init message and start servicing link requests
  return args;
  discard Q;
  
  while 'true' repeat
    receive linkArgs from linkQ;
    wrap copy of sysRM as linkArgs.value;
    return linkArgs;
  end while;
  
end process
