-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rshell.d
-- Author: Andy Lowry
-- SCCS Info: @(#)rshell.d	1.3 3/11/91

-- Interface for the remote shell facility.  A remote shell accepts a
-- command line along with stdin and stdout capability records, and
-- invokes the the given command.  It is primarily intended as a means
-- of executing an arbitrary Hermes command on a remote Hermes
-- interpreter.

rShell: using (stdio, rManager, terminalIO)

definitions
  
  -- rShell interface attempts to run the given command line.  If
  -- there are any detectable problems, Failure exception is raised.
  rShell: callmessage (
    cmdLine: charString,
    stdin: stdin,
    stdout: stdout,
    terminal: terminalFunctions
  )
  constant (cmdLine, stdin, stdout, terminal)
  exit {full}
  exception Failure {full};
  
  rShellQ: inport of rShell {full};
  rShellFn: outport of rShellQ;
  
end definitions

