-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkscope.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)checkscope.d	1.3 1/19/92"
-- description:
-- initcheckscope is given some capabilities and returns a checkscope 
-- function. A checkscope function is given a path and returns 'true'
-- if the path is within a given "scope" and false otherwise.  
checkscope: using(root)
definitions 

checkscopeIntf: callmessage(
  path: charstring,
  result: boolean
) constant(path)
  exit {full}
  minimum {init(path)};
checkscopeQ: inport of checkscopeIntf {full(path)};
checkscopeFn: outport of checkscopeQ;

initcheckscopeIntf: callmessage(
  cwd: charstring,
  environ: root!environ,  
  checkscope: checkscopeFn
) constant(environ)
  exit {full}
  minimum {full(environ)};
initcheckscopeQ: inport of initcheckscopeIntf { full(cwd), full(environ) };
initcheckscopeFn: outport of initcheckscopeQ;

end definitions
