-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: mustmake.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)mustmake.d	1.2 3/13/90"

-- mustmake takes a file name and a table of dependent files.  It returns true if
-- the any of the dependencies has a later (modification) time stamp than the file.  
mustmake: using(make, timestamp)
definitions

mustMakeInitIntf: callmessage(
   timestampFn: timestamp!tsrequestFn,
   mustMake: mustMakeFn
   ) constant (timestampFn)
     exit {full(timestampFn),full(mustMake)};
mustMakeInitQ: inport of mustMakeInitIntf {full(timestampFn)};
mustMakeInitFn: outport of mustMakeInitQ;

mustMakeIntf: callmessage (
   fn: charstring,
   dependencies: make!charstringSet,
   mustMake: boolean
   ) constant ( fn, dependencies )
     exit { full }
     exception statusfailure {init(fn), init(dependencies)};
     -- currently this exception cannot arise since the cprocess that returns 
     -- the file status cannot raise an exception.   
mustMakeQ: inport of mustMakeIntf {init(fn), init(dependencies)};
mustMakeFn: outport of mustMakeQ;

end definitions
