-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initcheckscope.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initcheckscope.p	1.4 3/2/92"
-- description:
-- initcheckscope is given some capabilities and returns the checkscope 
-- function. The checkscope function is given a path and returns 'true'
-- if the path is in MKSCOPE and false otherwise.  
initcheckscope: using(checkscope,common,root)
process (q: initcheckscopeq)

declare
  cm: initcheckscopeIntf;
  cwd: charstring;
  enventry: root!enventry;
  path: charstring;
  mkScope: common!charstringList;  -- set of path prefixes corresponding to

  checkscopeq: checkscope!checkscopeq;
  checkscopeFn: checkscope!checkscopeFn;

begin

  receive cm from q;
  cwd := cm.cwd;
-- convert the unix-style MKSCOPE path variable into a charstringList mkscope
  block begin
    enventry <- var in cm.environ where (var.variable = "MKSCOPE");
    path <- enventry.value;
  on (NotFound)
-- if not found then path is taken to be the current working dir
    path := cwd;
  end block;

  new mkScope;
  block declare
    part: charstring;
    colpos: integer;
    colon: char;
  begin
    while size of path > 0 repeat
      colpos <- position of c in path where (c = ':');
      extract part from c in path where (position of c < colpos);
      insert part into mkScope;
      remove colon from path[0];
    end while;
  on (notFound)
    insert path into mkScope;
  end block;
  
  for dir in mkScope[] inspect
    block declare
      dirCopy: charstring;
      newdir: charstring;
      part: charstring;
      slashpos: integer;
      slash: char;
    begin
      remove dirCopy from mkScope[position of dir];
      if (dircopy[0] = '/') then
	newdir <- "";
      else
	newdir := cwd | "/";
      end if;
      if dirCopy[size of dirCopy - 1] <> '/' then
	insert '/' into dirCopy;
      end if;
      while size of dirCopy > 0 repeat
	slashpos <- position of c in dirCopy where (c = '/');
	extract part from c in dirCopy where (position of c < slashpos);
	remove slash from dirCopy[0];
	select part
	where (".")
	  -- no change to directory
	where ("..")
	  if exists of s in newdir where (s = '/') then
	    newdir <- every of c in newdir where
		(exists of s in newdir where
		  (s = '/' and position of s > position of c));
	  end if;
	otherwise
	  newdir <- newdir | part | "/";
	end select;
      end while;
      remove slash from newdir[size of newdir - 1];
      insert newdir into mkScope at position of dir;
    end block;
  end for;

-- now we have constructed mkScope, return the outport to the checkscope func
  new checkscopeq;
  connect cm.checkscope to checkscopeq;
  return cm;
  discard q;

-- forever process requests
  while 'true' repeat
    block
    declare
      checkM: checkscopeIntf;
      prefix: charstring;
    begin
      receive checkM from checkscopeq;
      prefix <- every of c in checkM.path where
	  (exists of slash in checkM.path where
	    (slash = '/' and position of slash > position of c));
      if size of prefix = 0 then
	prefix := cwd;
      end if;
      if exists of p in mkScope where (p =  prefix)
      then 
         checkM.result <- 'true';
      else 
         checkM.result <- 'false';
      end if;
      return checkM;
    end block;
  end while;
on (disconnected)
end process
