-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkloop.p
-- Author: Rob Strom
-- SCCS Info: @(#)checkloop.p	1.2 10/27/89

-- Function: Compute GLB of top and bottom of loop.  Determine whether
--           TS at top has changed (in which case loop must be re-analyzed).
--           Save any coercions generated
-- Algorithm:
-- 1. Generate soft coercion entry for loop clause, if it doesn't already exist.
-- 2. Store beginning of loop typestate in it.
-- 3. Softglb the end of loop typestate.
-- 4. If the beginning of loop typestate is now different,
--    then indicate that the loop must be re-analyzed
-- 5. If there are any coercions, then we must save them
checkloop : USING( tscheck  ) PROCESS ( CheckLoopInit :  CheckLoopInport )
  DECLARE
    FP: CheckLoopCall;
    SoftCoercion: SoftCoercion; -- coercion entry for loop
    Nothing:Empty;
  BEGIN
    RECEIVE FP From CheckLoopInit;
    BLOCK
      -- 1.
      BEGIN
        REMOVE SoftCoercion from C IN FP.Context.HandlerCoercions[FP.LoopClause];
      ON (NotFound)
        NEW SoftCoercion;
        SoftCoercion.ClauseId := FP.LoopClause;
	UNITE SoftCoercion.Dataflow.Branched FROM EVALUATE CoercionInfo: CoercionInfo FROM
	  NEW CoercionInfo;
	  CoercionInfo.TargetTS := FP.BeginLoopTS;
	  NEW CoercionInfo.Drops;
	  END;
      END BLOCK;
    -- 2.
    -- 3.
    CALL FP.Services.SoftGLB(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, FP.EndLoopTS, CONVERT OF SIZE OF FP.Context.Scopes - 1, SoftCoercion.Dataflow);
    -- 4.
    REVEAL SoftCoercion.Dataflow.Branched;
    IF SoftCoercion.Dataflow.Branched.TargetTS <> FP.BeginLoopTS
      THEN
        FP.Recheck <- 'true';
        FP.BeginLoopTS := SoftCoercion.Dataflow.Branched.TargetTS;
      ELSE
        FP.Recheck <- 'false';
      END IF;    
    -- 5.
    IF SIZE OF SoftCoercion.Dataflow.Branched.Drops > 0
      THEN
        INSERT SoftCoercion INTO FP.Context.HandlerCoercions;
      END IF;
    RETURN FP;
  END PROCESS
