-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pohide.p
-- Author: Rob Strom
-- SCCS Info: @(#)pohide.p	1.3 3/13/90

pohide : USING( tscheck, Predefined  ) PROCESS (PostDropComponentsInit : DeterminePostconditionInport )
-- Compute Postcondition of Hide
-- Algorithm:
-- 1. If there is a CASE attribute, CASE(V, V.X), then
--    1.1. put the CASE attribute into the Drops list
--    1.2. Perform makeuninit action for V.X, namely:
--      For each attribute involving V.X, 
--      put that attribute in the Drops list
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    AttributesInvolvingVDotX : Typestate;
    EmptyAttributeList:  Typestate;
  BEGIN
    RECEIVE FP FROM PostDropComponentsInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
      BLOCK
        BEGIN
          INSPECT CaseAttr IN FP.CurrentTS WHERE(EVALUATE Exists:Boolean FROM
            Exists <- CASE OF CaseAttr.Name = 'case';
            IF Exists
              THEN
                Exists <- Object IN CaseAttr.Objects WHERE(POSITION OF Object = 0) = SourceObject;
              END IF;
            END)
            BEGIN
              INSERT COPY OF CaseAttr INTO FP.NormalPostcondition.Drops;
	      NEW EmptyAttributeList; 
--	      print FP.NormalPostcondition.Drops;
	      CALL FP.Services.Involving(FP.CurrentTS, Object IN CaseAttr.Objects WHERE(POSITION OF Object = 1), EmptyAttributeList, AttributesInvolvingVDotX);
--     print AttributesInvolvingVDotX;
--            MERGE AttributesInvolvingVDotX INTO FP.NormalPostcondition.Drops;
              BLOCK
                DECLARE
                  A: Attribute;
                BEGIN
                  WHILE ('true')
                    REPEAT
                      REMOVE A FROM Attr IN AttributesInvolvingVDotX WHERE('true');
                      BLOCK
                        BEGIN
                          INSERT A INTO FP.NormalPostcondition.Drops;
                        ON (DuplicateKey)
                        END BLOCK;
                    END WHILE;
                END BLOCK;  
--     print  charstring # "merged";
--     print FP.NormalPostcondition.Drops;
	    END INSPECT;
	  ON (NotFound)
	  END BLOCK;
      END INSPECT;
    RETURN FP;
  END PROCESS
