-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pokill.p
-- Author: Rob Strom
-- SCCS Info: @(#)pokill.p	1.1 1/9/92

pokill : USING( tscheck, Predefined  ) PROCESS (PostKillConstraintsInit : DeterminePostconditionInport )
-- 
-- KillConstraints
-- Called with an object which has been modified
-- If this object or any ancestor has a constraint/checked/checkeddefinitions,
-- drop the constraint
  DECLARE
    FP: DeterminePostconditionCall ;
    SizeOfComponents: integer; -- how many components in the object
    AttributesInvolvingSource : Typestate;
    AttributesInvolvingDestination : Typestate;
    EmptyAttributeList:  Typestate;
    DeletedAttribute: Attribute;
  BEGIN
    RECEIVE FP FROM PostKillConstraintsInit ;
    INSPECT SourceObject IN FP.Statement.Operands[FP.Affected_Operands[0]]
      BEGIN
        SizeOfComponents <- SIZE OF SourceObject.Components;
        MERGE EVERY OF Attribute IN FP.CurrentTS WHERE(EVALUATE Select: boolean FROM
          BLOCK
            BEGIN
              SELECT (CASE OF Attribute.Name)
                WHERE ('checked')
                  EXIT CheckKill;
                WHERE ('checkeddefinitions')
                  EXIT CheckKill;
                WHERE ('constraint')
                  EXIT CheckKill;
                OTHERWISE
                  Select <- 'false';
                END SELECT;
            ON EXIT(CheckKill)
              Select <- EXISTS OF Parm IN Attribute.Objects WHERE(EVALUATE Kills: boolean FROM
                Kills <- SourceObject.Root = Parm.Root AND SIZE OF Parm.Components <= SizeOfComponents;
                IF Kills
                  THEN
                    Kills <- FORALL OF Component IN Parm.Components WHERE(Component = SourceObject.Components[POSITION OF Component]);
                  END IF;
                END);
            END BLOCK;
          END) INTO FP.NormalPostcondition.Drops;
      END INSPECT;
    RETURN FP;
  END PROCESS
