-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: popolyts.p
-- Author: Rob Strom
-- SCCS Info: @(#)popolyts.p	1.5 1/31/92

popolyts : USING( tscheck, Predefined, Errors  ) PROCESS (PostPolymorphTSInit : DeterminePostconditionInport )
-- Postcondition for unwrap
-- Algorithm:  
-- Substitute the destination object into the formal typestate
-- These attributes are to be added to the typestate
-- Delete any other attributes involving the object, or inconsistent
--  with this typestate
  DECLARE
    FP: DeterminePostconditionCall ;
    EmptyAttributeList: Typestate;
    AttributesInvolvingDestination: Typestate;
    DeletedAttribute: Attribute;
    AddedAttributes: Typestate;
    FullAttribute: Attribute;
    FullName: Attribute_Name;
    ErrorMessage: Error;
    ErrorObject: ErrorObject;
  BEGIN
    RECEIVE FP FROM PostPolymorphTSInit ;
    NEW EmptyAttributeList;
    REVEAL FP.Statement.Qualifier.Formal_Typestate;
    CALL FP.Services.Substitute(FP.Services, FP.Statement.Operands[FP.Affected_Operands[0]], FP.Statement.Qualifier.Formal_Typestate, AddedAttributes);
    UNITE FullName.Full FROM (EVALUATE E: Empty FROM END);
    FOR Attribute in AddedAttributes WHERE (Attribute.Name = FullName) INSPECT
      REMOVE FullAttribute FROM AddedAttributes[Attribute];
      NEW ErrorMessage;
      UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
      ErrorMessage.Code <- 'UnsupportedAttribute';
      NEW ErrorMessage.Objects;
      UNITE ErrorObject.Attribute FROM FullAttribute;
      INSERT ErrorObject into ErrorMessage.Objects;
      INSERT ErrorMessage into FP.Context.ErrorMessages;
    END FOR;
    MERGE AddedAttributes INTO FP.NormalPostcondition.Adds;
    CALL FP.Services.Involving(FP.CurrentTS, FP.Statement.Operands[FP.Affected_Operands[0]], EmptyAttributeList, AttributesInvolvingDestination);
    WHILE (SIZE OF AttributesInvolvingDestination > 0)
      REPEAT
	REMOVE DeletedAttribute FROM Attribute IN AttributesInvolvingDestination WHERE('true');
	IF EXISTS OF Mate IN FP.NormalPostcondition.Adds WHERE(Mate = DeletedAttribute)
	  THEN
	    DISCARD DeletedAttribute;
	  ELSE
	    INSERT DeletedAttribute INTO FP.NormalPostcondition.Drops;
	  END IF;
      END WHILE;    
    RETURN FP;
  END PROCESS
