-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: prereveal.p
-- Author: Rob Strom
-- SCCS Info: @(#)prereveal.p	1.2 3/13/90

-- prereveal:  Precondition for REVEAL
-- Algorithm:
-- 1. Split object V.X into V and X
-- 2. INIT(V) is the required TS
-- 3. Attributes Involving V will be the forbidden TS
prereveal : USING( tscheck, Predefined ) PROCESS ( CheckVarInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
    V: Objectname;
    X: ComponentId;
    InitObj: Typestate; -- required typestate
    HigherAttributes: Typestate; -- additional attributes above case typestate
    
  BEGIN
    RECEIVE FP FROM CheckVarInit ;
    -- 1.
    V <-  Obj IN FP.Statement.Operands WHERE(POSITION OF Obj = Offset in FP.Affected_Operands WHERE(POSITION OF Offset = 0));
    REMOVE X FROM Component IN V.Components WHERE(POSITION OF Component = SIZE OF V.Components - 1);
    -- 2.
    NEW InitObj;
    INSERT (EVALUATE InitX: Attribute FROM
      NEW InitX;
      NEW InitX.Objects;
      UNITE InitX.Name.Init FROM EVALUATE Nothing: Empty FROM END;
	INSERT COPY OF V INTO InitX.Objects;
      END) INTO InitObj;
    -- 3.
    CALL FP.Services.Involving(FP.CurrentTS, V, InitObj, HigherAttributes);
    MERGE InitObj INTO FP.Required;
    MERGE HigherAttributes INTO FP.Forbidden;
    RETURN FP;
  END PROCESS
