/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;

public abstract class RemoteObject
implements Remote,
Serializable {
    protected transient RemoteRef ref;

    protected RemoteObject() {
        this.ref = null;
    }

    protected RemoteObject(RemoteRef remoteRef) {
        this.ref = remoteRef;
    }

    public int hashCode() {
        if (this.ref == null) {
            return super.hashCode();
        }
        return this.ref.remoteHashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RemoteObject) {
            if (this.ref == null) {
                return object == this;
            }
            return this.ref.remoteEquals(((RemoteObject)object).ref);
        }
        if (object != null) {
            return object.equals(this);
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (this.ref == null) {
            return string;
        }
        return String.valueOf(string) + "[" + this.ref.remoteToString() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException("Invalid remote object");
        }
        objectOutputStream.writeUTF(this.ref.getRefClass(objectOutputStream));
        this.ref.writeExternal(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            Class clazz = Class.forName(String.valueOf(RemoteRef.packagePrefix) + "." + objectInputStream.readUTF());
            this.ref = (RemoteRef)clazz.newInstance();
            this.ref.readExternal(objectInputStream);
            return;
        }
        catch (InstantiationException instantiationException) {
            throw new UnmarshalException("Unable to create remote reference", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnmarshalException("Illegal access creating remote reference");
        }
    }
}

