/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class Signer
extends Identity {
    private PrivateKey privateKey;

    protected Signer() {
    }

    public Signer(String string) {
        super(string);
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public PrivateKey getPrivateKey() {
        this.check("get.private.key");
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        this.check("set.private.keypair");
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null || privateKey == null) {
            throw new InvalidParameterException();
        }
        this.setPublicKey(publicKey);
        this.privateKey = privateKey;
    }

    String printKeys() {
        String string = "";
        PublicKey publicKey = this.getPublicKey();
        string = publicKey != null && this.privateKey != null ? "\tpublic and private keys initialized" : "\tno keys";
        return string;
    }

    public String toString() {
        return "[Signer]" + super.toString();
    }
}

